## CSV Table Query

Use the CSV (table definition) data source to define the actual input data of a widget in the dashboard editor.

#### Syntax

The definition is similar to a CSV file where the first line is defining the names of the columns. A column name may be
followed by `@property-name` in order to define a property for the column.

As an example the definition:

```
Country,Year,Population,Country@Color
France,2020,65273511,blue          
France,2010,62879530,blue          
Spain,2020,46754778,green         
Spain,2020,46931015,green         
```

Is creating the tidy table:

| Country   | Year     | Population    |
| :---      | :---     |       ---:    |
| France    | 2020     | 65'273'511    |
| France    | 2010     | 62,879,530    |
| Spain     | 2020     | 46'754'778    |
| Spain     | 2020     | 46'931'015    |

Where the column `Country` contains the following `Color` property:

| Color   |
| :---    |
| blue    |
| blue    |
| green   |
| green   |

Note that if you are using a CSV table query for a chart such as Donut, Line, Column or similar, and your axis is of type numeric such as `Year`, then the chart will consider both the `Year` numeric data and your value data as input values without a defined axis. To solve this, change  the column `Year` to *Character* thanks to the [Set Type transformation](../tidyTable/transformations/TransformationSetType.md). 

##### Spaces, Delimiters

Do not use spaces at the start and the end of the values, if you want them to use quoted fields. The same way, use quoted
fields to have delimiters in values:

```
" a,b",c
1,2
```

#### See Also

See this [page](FilterTableDefinitionQuery.md) for filter widget queries defined using a CSV (table definition).

_
