## SQL Query

The SQL data source allows for the input data of a widget to directly be the result of an SQL query.

#### Syntax

The definition is the usual SQL usual syntax. 

As an example the definition:

```
SELECT * FROM customer_list        
```

is creating the tidy table:

| ID   | name      | city      |
| :--- | :---      | :---      |
| 1    | Luis      | Brest     |
| 2    | Lauren    | Le Mans   |
| 3    | Rita      | Toulon    |
| 4    | Virginia  | Toulouse  |

#### Events

Widgets can fire [events](../interactions/Events.md) when a user interacts with them. You can use these events to filter
or change your query, so that the data used by the widget changes according to these interactions.

In order to use the value of those events within a query (or any other textual field), a special notation aka.
`Event Accessor` is required: `@{eventName...}`:

    @{eventName}              : retrieve the default (depending on the usage context) value of the event possibly empty
    @{eventName!defaultValue} : defines a default value to use if the event value is empty
    @{eventName:'some text'}  : if event exists, displays the string "some text" (without single quotes)
    @{eventName:asCaption}    : retrieve the caption of the event (you can use :caption as well)
    @{eventName:asSql}        : retrieve the value of the event as a valid SQL statement

Find [here](../interactions/Events.md#event-accessors) the complete list of event accessors.


#### Example 1: MDX filter filtering an SQL Query

Assuming an event called `myYear` has been fired in the dashboard, add the event in the where clause of your SQL-query as follows:

```
select * from customer_list
where year in ( @{myYear:asSql} )
```

The `asSql` is needed as an event accessor in order to retrieve a valid SQL statement to be used in the SQL query. In fact:
- `@{myYear:asSql}` will return a year (single selection) or a list of years (multi selection) with each year in quotation marks, i.e. *"2015","2018","2022"*, 
- whereas `@{myYear}`returns *2015,2018,2022* which would not be valid within this SQL statement.


#### Example 2: SQL filter filtering an SQL Query

Assume the event `myYear` is generated by an [SQL filter](FilterSqlQuery.md). The syntax for the receiving SQL query is
the same as [example 1](#example-1-mdx-filter-filtering-an-sql-query). The `asSql`is needed in order to retrieve the
values in a valid SQL format even though it is coming from an SQL filter.


#### See Also

See this [page](FilterSqlQuery.md) for filter widget queries using an SQL Query (Filter).

_
