## MDX Query Builder

Most widgets need data to build and display their content. To build the query for this data, use the graphical query
builder that allows for drag&drop setup. This query editor opens by default when opening a widget. Below we show the
query builder for the line chart.

![img.png](images/builder-example.png)

In the top of the editor, you have the 'Run' button to run the query and show the result in the bottom of the editor.
With the 'Datasource' button, you can change the source for the query. With 'To Statement', you can switch to the text
query editor.

On the left, you have the mappable fields of the widget where you can drag and drop hierarchies, levels and measures.
These are
displayed on the right in a tree-like structure. You can expand the tree to find hierarchies, levels and measures, or
you can use the search bar on the top right of the widget editor. Below the mappable fields, you can set the cube for
the query.

Each mappable field that allows for levels, members and hierarchies, has the option 'Empty MDX Axis' to filter the null
values. This option removes rows in the result if the combination of members does not have data in the measures.

To view the query generated by the builder, you press 'To Statement' and then you press 'Update Query'. This shows the
query generated by the builder.

### Changing the order of measures

If you drag and drop multiple measures into a field, then they will join into a single chip. To change the order of the
members, click on the chip. In the screen that opens on the right, you can drag and drop the members
into the order you want.

![img.png](images/reorder-measures-in-builder.png)

### Adding MDX functions

After dragging and dropping a member into a mappable field, you can click on the item to open a window with additional
information. Here, you can click on 'Add Function' to add an MDX function to the hierarchy or level. In the image below,
we added a top count on the `Year` set.

![img_1.png](images/mdx-function-example.png)

If you do not find the function you want in the list of functions, then you can add your own function with the 'MDX Set'
function. For example, to reverse the items in the level, you use the `MDX Set` function with `reverse($set)` as value
in `MDX ($set)`. Note that `$set` is a placeholder for the set-expression.

For the complete list of possible MDX functions, we refer to
the [icCube MDX function reference](../../server/mdx/functions.md).

### Adding a Calculated Measure

You add a calculated measure by dragging and dropping the 'New Calculated Measure' item from the tree into the measures
field. This opens a window where you can set the name and the function for the calculated measure. Clicking on the
pencil opens an editor where you can write the MDX code for the measure.

### Filtering the Query With Events

If the dashboard has widgets that generate events, then the query builder shows the event-names in the top of the tree.

![img.png](images/query-builder-events.png)

You can drag and drop these into the _Filter_ field if the widget allows for it.

### Adding Member Properties

If a hierarchy has member properties, then you can add them to the query by dropping them into the axes
as you would do for a member crossjoin. Alternatively, you can drop the properties into the measures axis
but this might break the `non empty` behavior logic (use with care). More details can be found 
[here](../../server/post_processing/DimensionProperties.md).

![img.png](images/query-builder-properties.png)

_
