## CSV Table Query (Filter)

To customize the items in a filter even more, you can use the CSV (table definition) data source to define custom items
and events.

#### Syntax

The definition follows the rules from a CSV file. See this [page](TableDefinitionQuery.md#syntax) for more details on
general CSV table queries.

#### Items / Members Sets

Filters can list measures, dimensions, or other items. For example, the filter can act as a query changer.

The following table definition lists measures:

```
item                , item@uniqueName
Amount              , [Measures].[Amount]
#Sales              , [Measures].[#Sales]
Amount AVG          , [Measures].[Amount AVG]
```

The following lists dimensions:

```
item                , item@uniqueName
Continent           , [Geography].[Geography].[Continent]
Article             , [Product].[Article].[Article]
Customer Type       , [Customer].[Customer].[Type]
```

Note that you need to use the `uniqueName` (case-sensitive syntax) of the member.

See this [page](../widgets/Filters.md) for filter widgets examples.

#### Application Notifications

A column can hold application notifications using predefined properties. On selection, the filter will fire the
corresponding application notification. Such a notification could be, for example, a trigger for printing the report.

The following table definition:

```
action              , action@appNotificationType
Print               , print-report
Print (Dialog)      , print-report-dialog
Print without state , print-report-without-state
Edit dashboard      , edit-report
Logout              , logout
```

Generates the tidy table:

| action<br>`<character>` | action@appNotificationType<br>`<character>` | 
|:------------------------|:--------------------------------------------|
| Print                   | print-report                                |
| Print (Dialog)          | print-report-dialog                         |
| Print without state     | print-report-without-state                  |
| Edit dashboard          | edit-report                                 |
| Logout                  | logout                                      |


If used as the source of a buttons list, clicking on the first button (Print) will trigger the print report notification.

See this [page](../interactions/AppNotifications.md) for detailed information on application notifications.

#### Widget Actions

A column can hold widget actions using predefined properties. On selection, the filter will fire the corresponding widget action. Such a notification could be, for example, a trigger for exporting a widget's data to Excel in the form of a filter/button. 

The following table definition:

```
action              , action@appNotificationType
Clear Selection     , clear-selection-all-widgets
Reset Selection     , initialize-selection-all-widgets
```

Generates the tidy table:

| action<br>`<character>`| action@appNotificationType<br>`<character>`| 
| :---                   | :---                                       |
| Clear Selection        | clear-selection-all-widgets                |
| Reset Selection        | initialize-selection-all-widgets           |

If used as the source of a buttons list, clicking on the first button (Clear Selection) will clear any selection made in the dashboard, default or done by the user.

See this [page](../interactions/WidgetActions.md) for detailed information on widget actions.



### Events

The filter publishes the [event](../interactions/Events.md) set in the interaction tab. This way, it can communicate with other widgets in the
dashboard and effectively filter their queries (or display event content).

A default event name is given to your filter widget, you may change it in _Interaction_ > _Selection_ > _Publish Selection_. 
It is recommended to use recognizable names, so you can easily use them later. For example, if your
filter is listing Years, name it `years`. 

To apply this filter to *all* widgets in your dashboard, go to the widget's menu (top right icon)
and click on `Add Event to Queries`.

To apply this filter to individual widgets please refer to the event section of the widget's query:

- [MDX](MdxQuery.md#events) (e.g., filtering the cells, generating the axis content)
- [SQL](SqlQuery.md#events) (e.g., generating the `WHERE` clause)

#### See Also

See this [page](TableDefinitionQuery.md) for chart and table widget queries defined using a CSV (table definition).

_
