## Calculated Measures

You can use Calculated Measures to define a new measure in your widgets query. This is useful, for example, when you need a measure that is not defined in the schema, or when you need more sophisticated calculations.

Let's look at some examples:

- With common operators `+`,`-`,`*` and `/`:

```
[Measures].[Amount] - [Measures].[Cost]
```
- A percentage with value format:
```
([Measures].[Amount],[Geography].[Geography].[Country].[Spain]) / ([Measures].[Amount],[Geography].[Geography].[Continent].[Europe]), FORMAT_STRING='Percent'
```
- With [MDX functions](../../server/mdx/functions.md). The example below uses [DivN()](../../server/mdx/DivN.md) to
  divide
  two numbers. It gives an empty result if the two numbers are null/empty or if the denominator is equal to 0:

```
DivN([Measures].[Amount], [Measures].[#Sales])
```

- Lagged Sum over last 30 days:

```
Sum( [Time].[Time].currentMember.lag(1):[Time].[Time].currentMember.lag(30),[Measures].[Amount])
````

#### Some helpful notes

- You can make the calculated measure available in other widgets by including it in the schemas script.
- Use [Cell Properties](../../server/mdx/Cell%20Properties.md), such
  as [FORMAT_STRING](../../server/mdx/cellProperties/FORMAT_STRING.md), to add meta-info used for displaying the
  measure.
- Calculated members can reference other calculated members.
- You can use the functions you have created in your schema's script.
- For more examples of calculated measures, check
  the [Calculated Members](../../server/mdx_tutorial/calculated_members.md)
  tutorial.

_