## Printing

This document gives some general information about printing (i.e., exporting to a PDF file ) a dashboard.

### Multi. Page vs Static or Responsive Layouts

For a perfect rendering of the printed dashboards we strongly advise using a dashboard [layout](../layouts/Layouts.md)
based on paper
sizes (e.g., A4, Letter). The `Statos` theme contains a layout group named `Statos Print` with several examples.
When using such a layout, you're actually visually editing the pages of the generated PDF file.

When printing a single page layout dedicated for a desktop (e.g., `Statos Responsive Grid`, `Statos Static`, ...),
a conversion of the layout into a paper size based layout is being applied first.

The **width** of the dashboard is being scaled to fit the PDF page width. Each widget is being scaled accordingly
keeping its **width/height ratio**. Horizontal groups of widgets are kept on the same page as much as possible;
widgets are not spanning several pages unless they're using the vertical 'Auto Expand' option.

The actual **content of each widget** is being **scaled** as well according to a **predefined factor** as defined
in the theme of the dashboard. This single predefined factor allows for having a consistent PDF rendering of
each widget whatever the actual layout they are defined in. Note that when using a paper size based layout (e.g., A4),
the content of the widgets are possibly visually scaled on the screen to make the rendering as close as possible to
the generated PDF file. You can use the editor zoom to enlarge the widgets if their content is too small.

### Editor : Print In Browser

The `Print in Browser` button in the dashboard editor allows for quickly checking the look of the dashboard
as printed. This cannot perfectly reflect the actual PDF, but this should give a good idea. Note that Chrome
is eventually used to generate the PDF, so it's recommended to use this button from within the Chrome browser.

### Paper Size

The PDF files are generated according to a paper size (e.g., A4, Letter, ...). The available sizes are defined
within the server via the `icCube.xml` configuration file. Note that you can define the margins as well :

```xml

<paperSize
        name="A4"
        unit="mm"
        width="210"
        height="297"
        marginTop="10"
        marginBottom="10"
        marginLeft="10"
        marginRight="10"
/>
```

### Print Button

A [button](../widgets/ic3/misc/PrintButton.md) for printing the current dashboard. This is a shortcut alternative
to the print notification as described in the next section.

### Notifications

[Application Notifications](../interactions/AppNotifications.md) can be used to trigger the printing of the current
dashboard.

### Application Menu

When using a report application, the `print dialog` action allows for opening a print dialog for printing
the current dashboard.

### Theme / Layouts (Reporting API)

When printing a dashboard, the actual content of each widget is being scaled according to a predefined factor
as defined in the theme of the dashboard. This single predefined factor allows for having a consistent PDF
rendering of each widget whatever the actual layout they are defined in.

This factor is defined as following in the `Statos` theme:

    ic3 {

        ...

        widgetContentPrintScale : 0.64,

    }

Note that when using a paper size based layout (e.g., A4), the content of the widgets are possibly visually scaled
on the screen to make the rendering as close as possible to the generated PDF file. You can use the editor zoom to
enlarge the widgets if their content is too small.

The `Statos Print` layouts are scaling the widget content rendering :

    {
        layoutGroup: "Statos Print",
        layoutName: "A4",

        applyWidgetContentPrintScaleForRendering : true,

        ...
    }

### See Also

- detailed information about application notifications ([www](../interactions/AppNotifications.md))
- dedicated print button ([www](../widgets/ic3/misc/PrintButton.md))

_



