## Dashboards Content Localization

With _content localization_, you can translate the terms and sentences added on dashboards.
For example, chart titles, text widget content, renamed columns.

### Generate localization file

Once you have created your dashboard, go to the Dashboard Administration console, and on 'Localization', insert on the 'Dashboard Filter' field the folder's path where your dashboard is saved to.

Click on 'Filter Test', this will make sure you have selected the correct folder.

![demo0](images/demo0.png)

Click on 'Generate Tags'. This creates a list of all text content defined on the dashboards of the selected folder.

![demo1](images/demo1.png)

Click on 'Export Tags to Excel'. Create additional columns if needed for the desired languages to be translated (following [JAVA locale naming](../../server/mdx/icCubeLanguages.md)). **Remove** the 'report path', 'option(s)' and 'found in' columns. **Save** it as a CSV.

The tags define the default language. In the example above, the tags are the English text, so it is the default language. French and Spanish users see the translated parts in the dashboard.

With `contentLocalizationsFallbackLocale`, you can change the fallback to a language column instead of the tags. When enabled, you can use shorter tags. Read more about this setting in the [section below](#using-short-tags).

### Installing the content localization CSV

To install it, you upload the content localization CSV to the app-local folder.

![demo2](images/demo2.png)

Insert the following code into your ic3report-config.js file:

```typescript
    options.contentLocalizations = options.contentLocalizations || [];

    options.contentLocalizations.push(
        "translation_file.csv"
    );
  ```  

You will now be able to access the dashboard in English:

![demo3-en](images/demo3-en.png)

In French:

![demo3-fr](images/demo3-fr.png)

And in Spanish:

![demo3-es](images/demo3-es.png)

### Using short tags

You can also use short tags in the dashboards, and localize them in the csv file. This is handy when working with markdown texts containing multiple lines.

In this case it is advised to set a default language, or else the dashboard shows the tags for users for which there is no localized text. Add the following code into your ic3report-config.js file to set the default language.

```typescript
options.contentLocalizationsFallbackLocale = "en";  // Or your fallback locale.
```

For example, insert `my_tag` into the translation file with its respective multi-line text to be shown on your widget between quotes:
```
tag,fr,es,en
my_tag, "### Mon test

Salut le monde!",
 "### Mi prueba 

Hola mundo!", "### My test 

Hello world!"
```

Insert the tag on the markdown content within your widget:

![loc-multi-en](images/loc-multi-en.png)

When changing the Browsing Language, the multi-line text will be respectively translated into French:

![loc-multi-fr](images/loc-multi-fr.png)

And Spanish:

![loc-multi-es](images/loc-multi-es.png)

_
