## Responsive Layouts

A responsive layout automatically adjusts the positions and sizes of the widgets to fit different screen sizes.

Check the [live demo example](https://livedemo.iccube.com/icCube/report/viewer?ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FLayouts%2FGrid).

The responsive layout group contains by default the following layouts:

* Statos Grid : widgets stack on top of each other when reducing the page / browser width.
* Statos Grid (Split 50%) : widgets stack on top of each other when reducing the page / browser width in *two* phases.
  For example, if you have 4 widgets on a same row, a first split occurs when reducing the browser size
  where the two widgets on the right will move below the other two; and a second when reducing further, they will then
  stack individually on top of each other.

Configuring your own responsive layouts can be done on the theme. Find here
a [theme plugin example](https://github.com/ic3-software/ic3-demo-plugin-theme).

### Groups

In a grid layout, widgets are placed in rows. Within a row, a widget can span multiple columns. Should you want
to have a widget that spans multiple rows, you can create a group. Hold `Shift` to create a group while dragging
and dropping a new widget into your dashboard.

For example, the following arrangement of widgets is a group (two widgets vertically stacked and a third next to
them using the full height of the first two) :

![grid-group](images/grid-group.png)

### See Also

* [Static](StaticLayout.md) : a pixel perfect layout with optional horizontal scaling.
* [Print](PrintLayout.md) : a page oriented layout (e.g., A4, Letter, etc...).

_
