## Widget Actions

A column can hold widget actions using predefined properties. On selection, the filter will fire the
corresponding widget action. Such a notification could be, for example, a trigger for exporting a widget's data to Excel in
the form of a filter/button.

Most of these actions can also be found on the top right [user menu](UserMenu.md) of a widget. Creating a visible button can 
in some cases be more straightforward for the user, thus this widget actions functionality.

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FWidget+Actions).

To illustrate the steps on how to set up widget actions let's show how to manually create a
[Buttons filter](../widgets/ic3/filter/FilterButtons.md) listing an Export to Excel action:

![Export to Excel button](images/export-to-excel.png)

- Create your Buttons filter and change the _Query_ > _Data Source_ to *CSV (Table Definition)*. 
- The following table definition:
```
label           , label@eventName , label@eventValue
Export To Excel , exportToExcel   , My File Name
```

Generates the tidy table:

| label<br>`<character>`|
| :---                   |
| Export to Excel        |


Create a widget you want to export, and set the field Interactions > Widget Actions > Export to Excel to `exportToExcel`.

Clicking on Export to Excel button will therefore trigger the an export to Excel action of the widget, where the file name will 
by default be 'My File Name'.


The following actions are available:

- [Zoom In / Out](#zoom-in--out)
- [Show / Hide Data](#show--hide-data)
- [Reset Query](#reset-query)
- [Clear Selection](#clear-selection)
- [To Initial Selection](#to-initial-selection)
- [Clear State](#clear-state)
- [Export to Excel](#export-to-excel)
- [Export to SVG](#export-to-svg)
- [Export to PNG](#export-to-png)



##### Zoom In / Out
Allows to maximize the widget into full screen. To minimize it back, click on the 'Zoom In / Out' button of the widget's [user menu](UserMenu.md).

##### Show / Hide Data
Shows the widget's data in the format of a table.

##### Reset Query
If a drilldown was made within the widget, this allows to reset to the original query.

##### Clear Selection
Allows clearing out all selections made on the widget. See this [page](AppNotifications.md#clear-selection-all-widgets) for a clear selection action applied to the entire dashboard.


##### To Initial Selection
Allows to bring all selections made on the widget back to the default selections. This is particularly useful if the widget is a [filter](../widgets/Filters.md). See this [page](AppNotifications.md#initialize-selection-all-widgets) for a initialize selection action applied to the entire dashboard.

Note that if using this action in editor mode, you might need to refresh the dashboard in order for it to work properly.

##### Clear State
For the [Table](../widgets/ic3/chart/Table.md) widget only, allows to bring the table to its default state. Learn more about a table's state under the [Columns Header Menu](../widgets/ic3/chart/Table.md#configuration) configuration.

##### Export to Excel
Exports the widget's data into an XLSX file.

##### Export to SVG
Exports the widget's data into an SVG file.

##### Export to PNG
Exports the widget's data into a PNG file.


### See Also

See this [page](AppNotifications.md) for application notifications (e.g. Print).

_
