## OnNewEvent JS

This Javascript function defined at dashboard level allows for intercepting all [events](./Events.md) fired
in the dashboard and react accordingly.

If the function returns false, the event will not be propagated (kind of cancel).

You can fire other events as well and use JQuery to modify the dashboard DOM. Use JQuery with care as it might
collide with the internal React's state.

Define this function under Dashboard Settings > Javascript.

![onNewEvent](images/onNewEvent.png)

### Example

A simple example that fires a newYearEvent on each event sent to the year channel.

```javascript

if (context.getEventName(event) === "year") {

    const caption = context.getEventCaption(event);
    context.dispatchEvent("newYearEvent", "You are selecting year " + caption, context.getEventMdx(event));

}

```

### Function parameters

`context: IOnNewEventJsContext`

```typescript
export interface IOnNewEventJsContext {

    /**
     * A context cache that persist over calls.
     */
    getCache(): Map<string, any>;

    /**
     * Report user name.
     */
    getUserName(): string;

    /**
     * Report tenant, if any.
     */
    getTenant(): string | undefined;

    /**
     * Reporting version.
     */
    getReportingVersion(): string;

    /**
     * Returns true if the event is empty.
     */
    isEmptyEvent(event: IEventPayLoad): boolean;

    /**
     * The name of the event/channel.
     */
    getEventName(event: IEventPayLoad): string;

    /**
     * The caption of the event (i.e. 'United Kingdom').
     */
    getEventCaption(event: IEventPayLoad): string | undefined;

    /**
     * The MDX of the event (i.e. [Geography].[Country].&[UK]).
     */
    getEventMdx(event: IEventPayLoad): string | undefined;

    /**
     * The widgetId from the widget the event was generated, if available.
     */
    getEventWidgetId(event: IEventPayLoad): string | undefined;

    /**
     * Returns the widget jQuery object
     *
     * Using JQuery might conflit with React's state.
     * Use with care as you will modify the DOM directly.
     */
    getWidget$(widgetId: string): any;

    /**
     * Returns the widget header jQuery object.
     *
     * Using JQuery might conflit with React's state.
     * Use with care as you will modify the DOM directly.
     */
    getWidgetHeader$(widgetId: string): any;

    /**
     * Returns the widget header jQuery object (you can user text() to modify the header's title.
     *
     * Using JQuery might conflit with React's state.
     * Use with care as you will modify the DOM directly.
     */
    getWidgetHeaderTitle$(widgetId: string): any;
}
```

`event: any`

We strongly advise to use the `context` parameter to access event state (i.e, `getEventName(event)`)
for future stability of your source code.

### See Also

- [Events](Events.md) : general description of events.

_
