## Global Events

Global events are events that are automatically published (when available) in a dashboard. This page assumes the reader is familiar with [events](./Events.md). Below is the list of global events.

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FMiscellaneous%2FGlobal+Events).

| Event Name                                 | Description                                                                                                                                                                                                                                                                                                                    |
|--------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `ic3_userName`                             | The name of the icCube user.                                                                                                                                                                                                                                                                                                   | 
| `ic3_userLocale`                           | The locale of the icCube user.                                                                                                                                                                                                                                                                                                 |
| `ic3_userTenant`                           | The tenant (if existing) of the icCube user.                                                                                                                                                                                                                                                                                   |
| `ic3_userRole`                             | The role of the icCube user.                                                                                                                                                                                                                                                                                                   |
| `ic3_environmentName`                      | The name of the environment (if existing).                                                                                                                                                                                                                                                                                     |
| `ic3_environmentColor`                     | The color of the environment banner.                                                                                                                                                                                                                                                                                           |
| `ic3_reportName`                           | The name of the dashboard.                                                                                                                                                                                                                                                                                                     |
| `ic3_reportPath`                           | The path of the dashboard.                                                                                                                                                                                                                                                                                                     |
| `ic3_defaultSchemaName`                    | The name of the schema defined in the dashboard properties.                                                                                                                                                                                                                                                                    |
| `ic3_defaultCubeName`                      | The name of the cube defined in the dashboard properties.                                                                                                                                                                                                                                                                      |
| `ic3_defaultSchemaLastRefreshTimestamp`    | Timestamp about the last (default) schema load : possibly no data update (see data-update below).<br/><br/>This is the number of milliseconds since the epoch; use the `:mdx` accessor to display the ISO 8601 format.                                                                                                         |
| `ic3_defaultSchemaLastRefreshDatetime`     | The refresh timestamp formatted using the theme default datetime format.                                                                                                                                                                                                                                                       |
| `ic3_defaultSchemaLastRefreshDate`         | The refresh timestamp formatted using the theme default date format.                                                                                                                                                                                                                                                           |
| `ic3_defaultSchemaLastDataUpdateTimestamp` | Timestamp about the last (default) schema data changed.<br/><br/>This is the number of milliseconds since the epoch; use the `:mdx` accessor to display the ISO 8601 format.<br/><br/>E.g., an incr. load with no data won't change this timestamp.<br/>E.g., the timestamp of the actual schema load when restoring a backup. | 
| `ic3_defaultSchemaLastDataUpdateDatetime`  | The data-update timestamp formatted using the theme default datetime format.                                                                                                                                                                                                                                                   |
| `ic3_defaultSchemaLastDataUpdateDate`      | The data-update timestamp formatted using the theme default date format.                                                                                                                                                                                                                                                       |

### See Also

- [Events](Events.md) : general description of events.

_
