## Drilldown

Drilldown is a data navigation that allows to drill into categorical data, while ensuring data consistency even with the most complex many-to-many relations. 

Three drilldown strategies are available in icCube: standard/children, user defined and user select.

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FDrilldown).

Drilldowns can be applied on [Pivot Tables](../widgets/ic3/chart/PivotTable.md)
, [Tree Filter](../widgets/ic3/filter/FilterTree.md), but also on charts such
as [Column](../widgets/amCharts4/chart/AmCharts4RegularColumnChart.md)
or [Donut](../widgets/amCharts4/chart/AmCharts4DonutChart.md) charts.

There are three types of drilldown strategies:
  - [Standard/Children](#standardchildren)
  - [User Defined](#user-defined)
  - [User Select](#user-select)


You can also check how to display the [drilldown path](#drilldown-path) the user has performed.

### Standard/Children
The standard/children navigation allows to directly drill down into the defined levels of the hierarchy in your schema.
For instance, a Time dimension: Year > Quarter > Month > Day:

![drill-hier](images/drill-hier.png)

Set it under Interactions > Drilldown > Drilldown Type > Children.

![drill-std](images/drill-std.png)


### User Defined
Define a specific navigation thanks to an expression. This allows to jump from a dimension/hierarchy/level to another. For instance, Year > Article > Continent.

Set it under Interactions > Drilldown > Drilldown Type > MDX Expression.

![drill-mdx](images/drill-mdx.png)

The MDX expression for that specific drilldown has the following syntax:

```
IIF( $member.level is [Time].[Time].[Year],
    [Product].[Product].[Article]
    ,
IIF( $member.level is [Product].[Product].[Article],
    [Geography].[Geography].[Continent]
    ,
    ic3drilldownStop()
))
```


Activate the `Enable Filter` option, this will allow to calculate the values accordingly while drilling down, i.e., it adds a `FILTER BY` in the query.

Read more on drilldown MDX expressions on this [page](../query/DrilldownMdxExpression.md).


### User Select
Give full flexibility to the user, who will decide into which dimension/hierarchy/level he or she wishes to drill into.

Set it under Interactions > Drilldown > Drilldown Type > User Select.

![drill-sel](images/drill-sel.png)

The user will now be able to select the dimension he or she wishes to drill down into.

![drill-sel-nav](images/drill-sel-nav.png)

### Drilldown Path

To display the drilldown path on a text field, most commonly on the widget's title, set a name under _Interactions_ > _Events_ > _Publish Drilldown_, for example `drilldown-path`.

Then access it by inserting `@{drilldown-path}` in the widget's title. Learn about Event Accessors [here](Events.md#event-accessors).

![drill-path](images/drill-path.png)

The following [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FDrilldown) show drilldown paths on the widgets' titles.



_
