## Dashboard Save/Load State

Dashboards can save and load the state of the filters and widgets in it. When a user closes the dashboard and reopens it later, the dashboard has the same selection and filters. The state is the same as when the user closed the dashboard.

You can enable this setting in the Dashboard Settings. Navigate to the Filters section, and enable the _Autosave Filters to Local Storage_ option. 

Dashboards that have the setting enabled will save the state of the dashboard locally in the users' browser.

Check the [live dashboard example](https://livedemo.iccube.com/icCube/report/viewer?ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FSave%252FLoad+State) showcasing the save and load state behavior. 

### Control this Setting from the Theme

You can control the save/load state mechanism from the theme. You can set it in `ic3Theme.filterState`. Below is a snippet from the theme definition with the documentation on how to change it.

```typescript
/**
 * Options for saving the state of all dashboard filters into local storage.
 */
filterState?: {

    /**
     * Set to true to disable auto save for all dashboards/apps and make the option inactive.
     */
    disableFilterStateOption?: boolean;

    /**
     * The default value for auto-saving filter setting in the dashboards.
     */
    autosaveFilterStateToSessionStorage?: boolean;

    /**
     * The default value for auto-saving filter setting in the application filter panel.
     */
    autosaveAppFilterStateToSessionStorage?: boolean;

}
```

_
