## Application Notifications

A column can hold application notifications using predefined properties. On selection, the filter will fire the
corresponding application notification. Such a notification could be, for example, a trigger for printing the report in
the form of a filter.

Check
the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FInteractivity%2FApplication+Notifications).

![App Notification Event](images/event-app-notif.png)

A single Print Button is available as a widget, check this [page](../widgets/ic3/misc/PrintButton.md).

To illustrate the steps on how to set up application notifications - Print or others - let's show how to manually create a
[Buttons filter](../widgets/ic3/filter/FilterButtons.md) listing a Print notification action:

- Create your Buttons filter and change the _Query_ > _Data Source_ to *CSV (Table Definition)*. 
- The following table definition:
```
action,action@appNotificationType,action@appNotificationPayload
Print,print-report,
```

Generates the tidy table:

| action<br>`<character>`|
| :---                   |
| Print                  |

Clicking on a button will therefore trigger the print report notification.

The following notifications are available:


- [print-report-dialog](#print-report-dialog)
- [print-report](#print-report)
- [print-report-without-state](#print-report-without-state)
- [edit-report](#edit-report)
- [clear-selection-all-widgets](#clear-selection-all-widgets)
- [initialize-selection-all-widgets](#initialize-selection-all-widgets)
- [logout](#logout)


##### print-report-dialog

This notification is printing the current report opening first a dialog to enter several print parameters.

##### print-report

This notification is printing the current report with its state (e.g., selection, drilldown, etc.).

Use the `@appNotificationPayload` to define print parameters.

```typescript
{
      paperSizeName: /* optional */ "A5" | "A4" | "A3" | "B5" | "B4" | "Letter" | "Legal" | "Ledger" | "JIS-B5" | "JIS-B4";
      paperOrientation: /* optional */ "portrait" | "landscape";
      fileName     : /* optional */ string;

        // Expressed in paper units (Letter, Legal, Ledger in inches, others in mm).
    
      marginTop?: number;
      marginRight?: number;
      marginBottom?: number;
      marginLeft?: number;
}
```

Margins applied when the paper size does not match the dashboard layout size (e.g., a responsive grid layout).
Those numbers are expressed using the pageSizeUnits (Letter, Legal, Ledger in inches others in mm). When using
a paper based layout (e.g., `Statos A4`) then the margins as defined in the layout are applied.

The payload is an escaped JSON object:

```
action,action@appNotificationType,action@appNotificationPayload
Print,print-report,"{""paperSizeName"":""Letter"",""fileName"":""sales.pdf""}"
```

##### print-report-without-state

This notification is similar to the `print-report` notification except that the state of the dashboard is not sent to
the print server. Therefore, any change to the dashboard is ignored.

##### edit-report

This notification is opening the current dashboard within the Dashboard Editor.

##### clear-selection-all-widgets

This notification is clearing out all current widget selections. See this [page](WidgetActions.md#clear-selection) for a clear selection action applied to individual widgets.

##### initialize-selection-all-widgets

This notification is resetting all widgets to their initially defined selection. See this [page](WidgetActions.md#to-initial-selection) for an initialize selection action applied to individual widgets.

##### logout

This notification is logging out the current user.

### See Also

- dedicated print button ([www](../widgets/ic3/misc/PrintButton.md))
- general information about printing ([www](../printing/Printing.md))

_
