## How To: Transform Event Values

This guide describes how to change the fired event by a widget. Use these techniques if you want to apply the fired event on a different dimension or measure group.

Check the live example of this scenario here: the [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FTransform+Events).

#### Example 

For example, you have a measure group describing the current state of a record; and a measure group describing the historic values. In your dashboard, a user-click in the historical chart should filter the table with current values.

The issue is, the time dimension from the historic chart is not linked to the current measure group. The solution is to transform the clicked member from the time dimension to a dimension that _is_ linked to the current set.

### How to transform event values

1. Start with a chart or widget that has selection enabled with an event named e.g. `colClick`.
2. Add the Column > Add Property transformation.
3. Select here the column that is in the selection. In the example this is the _Year_ column.
4. Select the `Selection Event` Value property. The transformation now overrides the standard MDX value used in the selection. 
5. In the text expression, add your MDX template. The MDX value of the event will get the value from this template. For example,

```nonEmpty([Customer].[Customer].[Name], ($axis.mdxUniqueName$, [measures].[#Articles]))```

becomes

```nonEmpty([Customer].[Customer].[Name], ([Time].[Time].[Year].&[2019-01-01], [measures].[#Articles]))```

6. Now each time you use the `@{colClick}` event, icCube uses the template from step 5.

![img.png](images/transform-event.png)

_
