## How To: Embedded Dashboard with Constants

[Constants](../interactions/Constants.md) are especially useful when using embedded dashboards. This example will show
how to create a dashboard containing a filter, and an embedded dashboard.

Create a dashboard, i.e., 'master', containing a filter listing continents.
[Name it](../interactions/Events.md#publishing-an-event) as `continent`.

Create a second dashboard, i.e., 'embedded', that will be used to be embedded into the 'master'.
[Configure](../interactions/Constants.md#configuration) the value of the constant as Europe (MDX unique name:
`[Geography].[Geography].[Europe]`) and name it `continent`:

![img.png](images/constants-settings.png)

Insert a widget into the 'embedded' dashboard and define its query containing the `continent` event, which is now
available on the Query Builder's tree-like structure.

![img.png](images/constants-tree.png)

Insert the 'embedded' dashboard into the 'master' dashboard as a [widget](../widgets/ic3/misc/EmbeddedReport.md).

Now, when opening the 'master' dashboard, the 'embedded' dashboard will be initially showing values for Europe.

Check
the [live example](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FEmbedded+Dashboard+with+Constants)
of the 'master' dashboard.

_