
## How To: Create Connected Filters

Filters can filter other filters.

![Connected Filter Event](images/event-connected.png)

Check [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FConnected+Filters)
of connected filters.

To illustrate the steps on how to set up connected filters, let's take the example of
three [Buttons filters](../widgets/ic3/filter/FilterButtons.md), the first listing continents, the second countries, and
the third cities:
- Create your three button filters and add the according items above on each respective Query Builder.
- Go to the Interactions tab, and set their respective event names under `Selection > Publish Selection` (*continent*, *country* and *city*)
- On the second filter (*country*), drag & drop the *continent* event on the Filter field of the Query Builder.
- On the third filter (*city*), drag & drop the *country* event on the Filter field of the Query Builder.
- You can optionally set the events as mandatory, i.e., not display any countries unless a continent is selected. To do so, on your country filter, click the *continent* chip and check the `mandatory event` box.

Now when selecting a continent, the second filter will display the countries of that continent only. Same goes for the third with cities.

Note that events are transitive, no need to add both *continent* and *country* events to the last filter (cities), just the *country* one.

_
