## How To: Coloring

Coloring data helps users to have a quick, visual idea of the data they are reading. 
The objective is to attract the attention of the users to data. There are two main reasons to color-code data, [Consistency](#consistency) and [Management by Exception](#management-by-exception-mbe) ruling.

Check
these [live examples](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FColoring).


### Consistency 
To have consistent color definition for elements throughout your dashboards (i.e., Europe, is always blue, South America is always yellow, etc.), define consistent colors:

- at schema level (see the [@Ic3Color member property](../server/mdx/Member%20Custom%20Property.md))
- at dashboard level (using for example
  the [Categorical Color](../tidyTable/transformations/TransformationColorCategorical.md)
  or [Single Color](../tidyTable/transformations/TransformationColorSingle.md) transformations)

![color-consistency](images/color-consistency.png)

### Management by Exception (MBE)
Management by Exception is a technique to emphasize/highlight values that require special attention.

![color-mbe](images/color-mbe.png)

These rules can be defined by different color transformations such as:
  - [Ordinal Color](../tidyTable/transformations/TransformationColorOrdinal.md): color palette or gradient indicating a natural ordering (value or string, for example a survey response 'not satisfied' to 'very satisfied')
  - [Numeric Color](../tidyTable/transformations/TransformationColorNumeric.md): color palette or gradient based on numerical values
  - [Conditional Color](../tidyTable/transformations/TransformationColorConditionalJS.md): colors based on a custom conditional expression
  
![color-transf](images/color-transf.png)

_
