## How To: Create a Chart with Multiple Measures

Charts and tables can display several measures at once. Below are a few examples on how to configure tables and charts to display multiple measures:

  - [Example 1: multiple measures as columns on flat tables](#example-1-multiple-measures-as-columns-on-flat-tables)
  - [Example 2: measures on column groups (pivot tables)](#example-2-measures-on-column-groups-pivot-tables)
  - [Example 3: several measures on line charts](#example-3-several-measures-on-line-charts)
  - [Example 4: several measures on column charts](#example-4-several-measures-on-column-charts)
  - [Example 5: combo charts with more than two measures](#example-5-combo-charts-with-more-than-two-measures)
  - [Example 6: visual separation of measures on a chart (Level)](#example-6-visual-separation-of-measures-on-a-chart-level)

Check
the [live dashboard](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FChart+with+Multiple+Measures)
for these examples.

### Example 1: Multiple Measures as Columns on Flat Tables

![Multi measures - table](images/multim-table.png)

To display measures as columns on a table, on the Query Builder, instead of draging and dropping measures on the
_Measures_ fields, drag and drop them on the _Columns_ field.

![Multi measures - table editor](images/multim-edit-table.png)

### Example 2: Measures on Column Groups (Pivot Tables)

![Multi measures - pivot table](images/multim-pivot.png)

To display measures as columns on a pivot table, and separate them into groups, on the Query Builder, drag and drop your
group, here `Type`, on the _Columns_ field followed by your list of measures.

![Multi measures - pivot table editor](images/multim-edit-pivot.png)

### Example 3: Several Measures on Line Charts

![Multi measures - line](images/multim-line.png)

To display several measures on a same line chart, on the Query Builder, add your measures on the _Group_ field, choose
the _Axis_ (here `Years`) and add to the _Value_ field an 'All' Level of a hierarchy different from the other
hierarchies used here on this same query. In this example, do not take the `All-Level` from the `Time` hierarchy, take
for instance the `All-Level` of the `Customer` hierarchy.

![Multi measures - line editor](images/multim-edit-line.png)

### Example 4: Several Measures on Column Charts

![Multi measures - column](images/multim-col.png)

To display several measures on a same column chart, follow the [example 3](#example-3-several-measures-on-line-charts)
above.

### Example 5: Combo Charts with more than Two Measures

![Multi measures - combo](images/multim-combo.png)

To display more than the common two measures on a combo chart, on the Query Builder, drag and drop several measures as
needed on the _Line_ and _Columns_ fields.

In this example, `#Customers`, `#Sales` and `#Licences` are lines and `Amount` is represented as columns.

![Multi measures - combo editor](images/multim-edit-combo.png)

### Example 6: Visual Separation of Measures on a Chart (Level)

![Multi measures - level](images/multim-level.png)

To visually separate a chart, either line, column, area or the stacked version of these three, you can insert several
measures in the _Level_ field of the Query Builder.

In this example, the stacked bar chart has two levels for the `#Customers` and `#Sales` measures.

![Multi measures - level editor](images/multim-edit-level.png)

_
