## Gadgets

### Overview

A gadget is a preconfigured [widget](../widgets/Widgets.md) or collection of widgets, that can be used in dashboards.
Instead of adding to your dashboard an 'empty' widget where you need to configure its query, chart, box and other
options,
you can add a gadget that is 'ready' with data and configurations.

A live example of dashboard using gadgets is
available [here](https://livedemo.iccube.com/icCube/report/viewer?ic3demo=&ic3app=shared%3A%2FLive+Demo+App&ic3report=shared%3A%2FLive+Demo%2FHow+To%2FGadgets).

The purpose of the gadgets is not to modify the content of its query, but precisely to link a query to a widget. 
A common use case would be when a team familiar with the data model prepares gadgets for a non-technical team, 
the latter will be able to use the gadgets without worrying whether the underlying query is indeed correct. 
The dashboard creator will then only be given access to other features, such as Chart options. 

In addition to simplifying dashboard creation, gadgets allow consistency across dashboards. When a specific 
(and same) widget is required across multiple dashboards, consider creating a gadget, as any updates or adjustments 
made to a gadget will automatically propagate throughout all related dashboards, ensuring data uniformity and
efficiency.

### Creating Gadgets

In the Dashboard console, a Gadget Editor is available.

![console](images/console.png)

The creation of a gadget resembles the creation of a common widget: add a widget and configure its options
(Chart, Query, Transformation, Interactions, Box).

An additional 'Rights' tab is available. The options of the gadget are fixed unless specified otherwise.
This means that you can decide if certain options are modifiable or not when using this gadget in a dashboard.

For example, the image below shows a gadget where only its title will be modifiable.

![rights](images/gadget-rights.png)

Position and size of a gadget are naturally modifiable as well in a dashboard.

Notes:

- If the 'Query Filters' rights option is deactivated, the gadget will not be able to listen to any
  [events](../interactions/Events.md).

- Gadgets can be a single widget or a collection of widgets.

### Using Gadgets in a Dashboard

When creating a dashboard, an 'Add Gagdet' button is available next to the 'Add Widget' button.

![add-gadget](images/gadget-button.png)

Choose your gadget and drag & drop it into the dashboard. Taking the example above, when you edit the gadget,
you'll see that only its title can be changed:

![gadget-options](images/gadget-options.png)

along with Box > Rectangle configuration (position and size):

![gadget-size-pos](images/gadget-size-pos.png)

Notes:

- If a gadget is a collection of widgets (two or more) and the user deletes one of these widgets,
  the entire gadget will be deleted.

- If an existing gadget is modified, the changes will automatically propagate into all dashboards
  where this gadget in being used.

_



