## Documentation

In this folder we store the reference sources of all the documentation related to icCube Dashboards v8. This documentation is
- used in the Dashboards editor,
- used in the Dashboards help application,
- used for ic3-reporting-api, ic3-demo-plugin-js, ic3-demo-plugin-react , ic3-demo-plugin-theme projects (copy),
- used for generating the Website documentation.

### Content Convention

Here we list conventions for writing the documentation. Please try to follow these as closely as possible.

#### Start of Document 

Every .md file must start with a `## Title` line.

#### End of Document

Include a blank line and a `_` character.

#### Titles and Headings

Use title case.

#### Referencing the User

Use 'you' to reference the person editing the dashboard and reading the documentation. Use 'the user' to reference the consumer of the dashboard.

#### MDX Queries

Put MDX queries in a code block and format them, like so

```
SELECT 
    {[Measures].[#Sales], [Measures].[Amount]} ON 0,
    [Geography].[Geography].[Continent] ON 1
FROM [Sales]
```

#### Writing

Try to limit the use of the passive voice, e.g., "The option _Legend_ is used to control the settings for the legend.". Instead, use active voice. The above sentence then would be "You can control the settings of the legend with the options in _Legend_".

#### Embedded Queries

The reader of the documentation should be able to copy and paste the embedded definition into the query editor. Therefore, use a code block with a nicely formatted csv. See the example below.

```
name          , surname   , state
John          , Doe       , NY
Jack          , McGinnis  , CA
John D.M.     , Repici    , SD
Stephen       , Tyler     , CO
Joan          , Anne      , NJ
```

#### Tidy Tables

We show tidy tables like the example below.

|<b></b>|Country<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Continent<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Type<br><span style="font-weight:normal;color:gray">&lt;character&gt;</span>|Amount<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|Count<br><span style="font-weight:normal;color:gray">&lt;numeric&gt;</span>|
|:---|:---|:---|:---|---:|---:|
|0|France|Europe|cost|10|1|
|1|Holland|Europe|revenue|20|2|
|2|China|Asia|revenue|25|3|

You can reference rows, column names and types.

#### Referencing Options, Buttons and Tabs

Use italic. For example, "In _Chart_, you can use _Color column_ to set the colors.".

For values, use code. For example, "Map `Amount` into _Measure_".

#### More on Writing

See [https://material.io/design/communication/writing.html](https://material.io/design/communication/writing.html)

#### Images

We host the images ourselves. Links to GitHub should not be present.

ALWAYS use `[](path-to-image.png)`! Others do not work.

### Widget Template Naming Convention

The following naming convention applies to automatically find corresponding documentation for a widget template within a
given plugin.

First the language:

```
    documentation/
        en/
        fr/
```

Then the plugin id:

```
    documentation/
        en/
            amCharts4/
        fr/
            amCharts4/
```

Then add an entry for the type of widgets:

```
    documentation/
        en/
            amCharts4/
                chart/
        fr/
```

Eventually the widget id:

```
    documentation/
        en/
            amCharts4/
                chart/
                    AmCharts4DonutChart.md
        fr/
```

_
