/*
 * Copyright 2014 - 2020 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.iccube.builder.OlapBuilderConnectionPool;
import crazydev.iccube.builder.OlapBuilderContext;
import crazydev.iccube.builder.datasource.reader.OlapBuilderAbstractTableRowReader;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;

import java.util.Iterator;
import java.util.Map;

public class OlapBuilderExcelDataTableRowReader
        extends OlapBuilderAbstractTableRowReader<OlapBuilderExcelDataTable, OlapBuilderExcelConnection>
{
    /**
     * Google stuff support ...
     */
    private final OlapBuilderExcelConnection myConnection;

    private final int startingPos;

    private Map<String, Integer> columnMapping;

    private Iterator<Row> rowIterator;

    private int rowNum;

    public OlapBuilderExcelDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderExcelDataTable table, int startingPos)
    {
        super(context, connectionPool, maxRowCount, table, table.getName());

        this.startingPos = startingPos;
        this.myConnection = null;
    }

    public OlapBuilderExcelDataTableRowReader(OlapBuilderContext context, OlapBuilderConnectionPool connectionPool, int maxRowCount, OlapBuilderExcelDataTable table, OlapBuilderExcelConnection connection, int startingPos)
    {
        super(context, connectionPool, maxRowCount, table, table.getName());

        this.myConnection = connection;
        this.startingPos = startingPos;
    }

    public String getSheetName()
    {
        return table.getSheetName();
    }

    @Override
    protected int numberOfHeaderRows()
    {
        return 1;
    }

    @Override
    public void doInit()
    {
        final OlapBuilderExcelConnection connection_;

        if (myConnection == null)
        {
            initConnection();
            connection_ = connection;
        }
        else
        {
            connection_ = myConnection;
        }

        final OlapBuilderExcelConnection.Accessor accesor = connection_.getSheetAccessor(getSheetName(), startingPos);
        rowIterator = accesor.iterator();

        // advance to the header
        columnMapping = table.createMapping(accesor.getHeaderRow());

        rowNum = startingPos;
    }

    @Override
    public boolean isRowSafe()
    {
        return true;
    }

    @Override
    public IOlapBuilderTableRow doNextRow()
    {
        if (!rowIterator.hasNext())
        {
            return null;
        }
        ++rowNum;
        final Row row = rowIterator.next();
        if (row != null)  // skip empty rows..
        {
            // more skip empty rows -> cadeau google docs
            boolean isEmpty = true;
            final Iterator<Cell> iter = row.cellIterator();
            while (iter.hasNext())
            {
                Cell next = iter.next();
                if (next.getCellType() != CellType.BLANK)
                {
                    isEmpty = false;
                    break;
                }
            }
            // got something
            if (!isEmpty)
            {
                return new OlapBuilderExcelTableRow(table, columnMapping, row);
            }
        }
        return null;
    }

    /**
     * Will be called as soon as the init method has been called (either successfully or on error).
     * Keep it safe as it is typically called from a finally block.
     */
    @Override
    public void done()
    {
        super.done();
    }

}
