/*
 * Copyright 1999 - 2014 icCube Software Llc.
 *
 * The code and all underlying concepts and data models are owned fully
 * and exclusively by icCube Software Llc. and are protected by
 * copyright law and international treaties.
 *
 * Warning: Unauthorized reproduction, use or distribution of this
 * program, concepts, documentation and data models, or any portion of
 * it, may result in severe civil and criminal penalties, and will be
 * prosecuted to the maximum extent possible under the law.
 */
package crazydev.iccube.builder.excel.datasource;

import crazydev.iccube.builder.model.def.IOlapBuilderDataSource;
import crazydev.iccube.builder.model.validation.OlapBuilderBaseDataSourceValidator;
import crazydev.iccube.builder.model.validation.OlapBuilderValidationContext;

public class OlapBuilderExcelDataSourceValidator extends OlapBuilderBaseDataSourceValidator
{
    public OlapBuilderExcelDataSourceValidator()
    {
    }

    @Override
    protected void doValidateFields(OlapBuilderValidationContext context, IOlapBuilderDataSource dataSource)
    {
        super.doValidateFields(context, dataSource);

        final OlapBuilderExcelDataSource myDataSource = (OlapBuilderExcelDataSource) dataSource;

        validateNotNullField(context, OlapBuilderExcelDataSource.FILE, myDataSource.getExcelFile());
    }

}
