/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import crazydev.common.exception.CdRuntimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;

public abstract class CdJodaTimeUtil {
    static final Chronology DEFAULT_CHRONOLOGY_UTC;
    public static final long DEFAULT_MILLIS_IN_DAY;
    private static final List<String> availableIDs;

    public static long toDefaultChronologyMillis(LocalDateTime dateTime) {
        Chronology chronology = dateTime.getChronology();
        if (DEFAULT_CHRONOLOGY_UTC.equals(chronology)) {
            return dateTime.getLocalMillis();
        }
        LocalDateTime converted = new LocalDateTime((Object)dateTime, DEFAULT_CHRONOLOGY_UTC);
        return converted.getLocalMillis();
    }

    public static LocalDateTime toDefaultChronologyDateTime(long millis) {
        return new LocalDateTime(millis, DEFAULT_CHRONOLOGY_UTC);
    }

    public static LocalDate toDefaultChronologyDate(long millis) {
        return new LocalDate(millis, DEFAULT_CHRONOLOGY_UTC);
    }

    public static int toDefaultChronologyDays(LocalDate dateTime) {
        Chronology chronology = dateTime.getChronology();
        if (DEFAULT_CHRONOLOGY_UTC.equals(chronology)) {
            if (dateTime.getLocalMillis() % DEFAULT_MILLIS_IN_DAY != 0L) {
                throw new CdRuntimeException("Hola");
            }
            return (int)(dateTime.getLocalMillis() / DEFAULT_MILLIS_IN_DAY);
        }
        LocalDateTime converted = new LocalDateTime((Object)dateTime, DEFAULT_CHRONOLOGY_UTC);
        return (int)(converted.getLocalMillis() / DEFAULT_MILLIS_IN_DAY);
    }

    public static LocalDate toDefaultChronologyDate(int days) {
        return new LocalDate((long)days * DEFAULT_MILLIS_IN_DAY, DEFAULT_CHRONOLOGY_UTC);
    }

    public static long localMillis(LocalDateTime dateTime) {
        return dateTime.getLocalMillis();
    }

    public static long localMillis(LocalDate date) {
        return date.getLocalMillis();
    }

    public static boolean isInBound(LocalDateTime begin, LocalDateTime end, LocalDateTime startBucket, LocalDateTime endBucket) {
        return (!startBucket.isBefore((ReadablePartial)begin) || !endBucket.isBefore((ReadablePartial)begin) && !endBucket.isEqual((ReadablePartial)begin)) && (!startBucket.isAfter((ReadablePartial)end) || !endBucket.isAfter((ReadablePartial)end));
    }

    public static LocalDateTime max(LocalDateTime date1, LocalDateTime date2) {
        return date1.isAfter((ReadablePartial)date2) ? date1 : date2;
    }

    public static LocalDateTime min(LocalDateTime date1, LocalDateTime date2) {
        return date1.isBefore((ReadablePartial)date2) ? date1 : date2;
    }

    public static LocalDate truncateTime(LocalDateTime datetime) {
        return new LocalDate(datetime.getYear(), datetime.getMonthOfYear(), datetime.getDayOfMonth());
    }

    public static int daysBetween(LocalDate date1, LocalDate date2) {
        Chronology chrono1 = date1.getChronology();
        if (chrono1.equals(date2.getChronology())) {
            long mil1 = date1.getLocalMillis();
            long mil2 = date2.getLocalMillis();
            long millisInDay = chrono1.days().getUnitMillis();
            return (int)((mil2 - mil1) / millisInDay);
        }
        return Days.daysBetween((ReadablePartial)date1, (ReadablePartial)date2).getDays();
    }

    public static boolean hasNoTimeInfo(LocalDateTime datetime) {
        return datetime.getMillisOfDay() == 0;
    }

    public static LocalDateTime toDateTime(LocalDate date) {
        return new LocalDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), 0, 0);
    }

    public static LocalDateTime toDateTime(java.time.LocalDateTime dateTime) {
        return new LocalDateTime(dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public static LocalDateTime toDateTime(java.time.LocalDate date) {
        return new LocalDateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0);
    }

    public static LocalDate toDate(java.time.LocalDateTime dateTime) {
        return new LocalDate(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth());
    }

    public static LocalDate toDate(java.time.LocalDate date) {
        return new LocalDate(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    public static List<String> availableIDs() {
        return availableIDs;
    }

    static {
        String[] jdkIDs;
        DEFAULT_CHRONOLOGY_UTC = DateTimeUtils.getChronology(null).withUTC();
        DEFAULT_MILLIS_IN_DAY = DEFAULT_CHRONOLOGY_UTC.days().getUnitMillis();
        availableIDs = new ArrayList<String>();
        for (String jdkID : jdkIDs = TimeZone.getAvailableIDs()) {
            if (ZoneId.SHORT_IDS.containsKey(jdkID)) continue;
            try {
                TimeZone jdkTZ = TimeZone.getTimeZone(jdkID);
                DateTimeZone jodaTZ = DateTimeZone.forTimeZone((TimeZone)jdkTZ);
                availableIDs.add(jdkID);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        Collections.sort(availableIDs);
    }
}

