/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.xml;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.xml.CdPasswordXmlAdapter;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.RuntimeStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.jetbrains.annotations.Nullable;

public abstract class CdXmlParametersUtils {
    public static final Logger GENERAL = Logger.getLogger((String)"icCube.general");

    private CdXmlParametersUtils() {
    }

    public static boolean startWithParam(String value) {
        return value.trim().startsWith("${");
    }

    public static String replace(@Nullable String value) {
        if (CdStringUtils.isNullOrBlank(value)) {
            return value;
        }
        StrSubstitutor subst = Substitutor.INSTANCE.subst;
        if (subst == null) {
            GENERAL.error((Object)"[XML] could not replace variables (not initialized)");
            return value;
        }
        try {
            return CdPasswordXmlAdapter.unmarshalVariable(subst.replace(value));
        }
        catch (RuntimeException ex) {
            GENERAL.error((Object)"[XML] could not replace variable", (Throwable)ex);
            return value;
        }
    }

    private static class Substitutor {
        private static final Substitutor INSTANCE = new Substitutor();
        @Nullable
        private final StrSubstitutor subst;

        private Substitutor() {
            RuntimeStrSubstitutor subst = null;
            try {
                subst = new RuntimeStrSubstitutor((StrLookup)new Interpolator(Collections.emptyMap()));
            }
            catch (RuntimeException ex) {
                GENERAL.error((Object)"[XML] could not initialize variable replacement", (Throwable)ex);
            }
            this.subst = subst;
        }
    }
}

