/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.xml;

import crazydev.common.security.AESCryptoEncoder;
import crazydev.common.security.Base64CryptoEncoder;
import crazydev.common.security.CdPassword;
import crazydev.common.utils.CdStringUtils;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class CdPasswordXmlAdapter
extends XmlAdapter<String, CdPassword> {
    private final AESCryptoEncoder defaultEncoder = new AESCryptoEncoder();

    @Nullable
    public static String unmarshalVariable(@Nullable String encryptedPassword) {
        if (CdStringUtils.isNullOrBlank(encryptedPassword)) {
            return encryptedPassword;
        }
        AESCryptoEncoder defaultEncoder = new AESCryptoEncoder();
        if (encryptedPassword.charAt(0) == defaultEncoder.getMarker()) {
            return defaultEncoder.decrypt(encryptedPassword.substring(1));
        }
        return encryptedPassword;
    }

    public CdPassword unmarshal(String encryptedPassword) {
        try {
            if (!encryptedPassword.isEmpty()) {
                if (encryptedPassword.charAt(0) == '\u2602') {
                    return new CdPassword(this.defaultEncoder.decryptOld(encryptedPassword.substring(1)), encryptedPassword);
                }
                if (encryptedPassword.charAt(0) == this.defaultEncoder.getMarker()) {
                    return new CdPassword(this.defaultEncoder.decrypt(encryptedPassword.substring(1)), encryptedPassword);
                }
                Base64CryptoEncoder b64encoder = new Base64CryptoEncoder();
                if (encryptedPassword.charAt(0) == b64encoder.getMarker()) {
                    return new CdPassword(b64encoder.decrypt(encryptedPassword.substring(1)), encryptedPassword);
                }
            }
            return new CdPassword(encryptedPassword, encryptedPassword);
        }
        catch (RuntimeException ex) {
            Logger.getLogger((String)"icCube.builder").error((Object)"[xml] encrypted password error", (Throwable)ex);
            return new CdPassword("ic3-invalid-password", encryptedPassword);
        }
    }

    @Nullable
    public String marshal(CdPassword clearPassword) {
        String decrypted;
        if (clearPassword == null || clearPassword.clear == null) {
            return null;
        }
        if (clearPassword.encrypted != null && !clearPassword.encrypted.isEmpty() && clearPassword.clear.equals(decrypted = this.unmarshal((String)clearPassword.encrypted).clear)) {
            return clearPassword.encrypted;
        }
        String encrypted = this.defaultEncoder.getMarker() + this.defaultEncoder.encrypt(clearPassword.clear);
        clearPassword.encrypted = encrypted;
        return encrypted;
    }
}

