/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.version;

import com.vdurmont.semver4j.Semver;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class CdVersion {
    public static final CdVersion MISSING = new CdVersion("9.0.0");
    public static final CdVersion MIN = new CdVersion("0.0.0");
    public static final CdVersion MAX = new CdVersion("100.0.0");
    private final String raw;
    private final Info info;

    private CdVersion(String raw) {
        this.raw = raw;
        this.info = Info.extractInfo(raw);
    }

    public static CdVersion create(String version) {
        return new CdVersion(version);
    }

    public static CdVersion get(Class clazz) {
        try {
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                return CdVersion.getMissing();
            }
            String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URI(manifestPath).toURL().openStream());
            Attributes attributes = manifest.getMainAttributes();
            String implementationVersion = attributes.getValue("Implementation-Version");
            if (implementationVersion == null) {
                return CdVersion.getMissing();
            }
            String builtDate = attributes.getValue("Built-Date");
            if (builtDate == null) {
                return CdVersion.getMissing();
            }
            return new CdVersion(implementationVersion.trim() + "+" + builtDate.trim());
        }
        catch (IOException | IllegalArgumentException | URISyntaxException ignored) {
            return MISSING;
        }
    }

    private static CdVersion getMissing() {
        try {
            SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss z");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            String extra = df.format(new Date());
            return new CdVersion(CdVersion.MISSING.raw + "+SNAPSHOT " + extra);
        }
        catch (RuntimeException ignored) {
            return MISSING;
        }
    }

    public boolean isNA() {
        return this.info.isNA();
    }

    public boolean isGreater(CdVersion other) {
        if (this.isNA() || other.isNA()) {
            return false;
        }
        return this.info.semver.isGreaterThan(other.info.semver);
    }

    public boolean isGreaterOrEqual(CdVersion other) {
        if (this.isNA() || other.isNA()) {
            return false;
        }
        return this.info.semver.isGreaterThanOrEqualTo(other.info.semver);
    }

    public boolean isLower(CdVersion other) {
        if (this.isNA() || other.isNA()) {
            return false;
        }
        return this.info.semver.isLowerThan(other.info.semver);
    }

    public int major() {
        return this.info.major();
    }

    public int minor() {
        return this.info.minor();
    }

    public int patch() {
        return this.info.patch();
    }

    public String asString() {
        return this.info.asString();
    }

    public String toString() {
        return this.info.toString();
    }

    static class Info {
        private static final Info NA = new Info(true, "0.0.0", new Semver("0.0.0")){

            @Override
            public boolean isNA() {
                return true;
            }
        };
        public final boolean na;
        public final String raw;
        public final Semver semver;

        private Info(boolean na, String raw, Semver info) {
            this.na = na;
            this.raw = raw;
            this.semver = info;
        }

        static Info extractInfo(String raw) {
            try {
                Semver info = new Semver(raw, Semver.SemverType.LOOSE);
                return new Info(false, raw, info);
            }
            catch (RuntimeException ex) {
                return NA;
            }
        }

        boolean isNA() {
            return false;
        }

        int major() {
            return this.semver.getMajor();
        }

        int minor() {
            Integer minor = this.semver.getMinor();
            return minor != null ? minor : 0;
        }

        int patch() {
            Integer patch = this.semver.getPatch();
            return patch != null ? patch : 0;
        }

        String asString() {
            return this.raw;
        }

        public String toString() {
            return this.asString();
        }
    }
}

