/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.collection.CdCollections;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CdTreeBuilder<NODE extends Node<T>, T> {
    List<NODE> nodes = new ArrayList<NODE>();

    public void addNode(NODE ... nodes) {
        this.nodes.addAll(Arrays.asList(nodes));
    }

    @Nullable
    public ITree<NODE, T> buildTree() {
        Tree tree = new Tree(null, null);
        if (this.nodes.isEmpty()) {
            return tree;
        }
        if (!this.sort(this.nodes)) {
            return null;
        }
        for (Node node : this.nodes) {
            if (tree.addNode(node)) continue;
            return null;
        }
        return tree;
    }

    public String asString() {
        StringBuilder builder = new StringBuilder();
        for (Node node : this.nodes) {
            builder.append("{").append(node.from()).append("}->{").append(CdCollections.toString(node.to(), "", ",")).append("}");
            builder.append("; ");
        }
        return builder.toString();
    }

    private boolean sort(List<NODE> nodes) {
        NodeComparator comp = new NodeComparator();
        for (int kk = 0; kk < nodes.size(); ++kk) {
            boolean switched = false;
            block1: for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                for (int j = i; j < nodes.size(); ++j) {
                    Node node1 = (Node)nodes.get(j);
                    if (comp.compare(node, node1) <= 0) continue;
                    CdCollections.switchItems(nodes, i, j);
                    switched = true;
                    continue block1;
                }
            }
            if (switched) continue;
            return true;
        }
        return false;
    }

    private static class Tree<NODE extends Node<T>, T>
    implements ITree<NODE, T> {
        private final NODE node;
        private final List<T> branchItems = new ArrayList<T>();
        private final List<ITree<NODE, T>> children = new ArrayList<ITree<NODE, T>>();

        protected Tree(Tree<NODE, T> parent, NODE node) {
            if (parent != null) {
                this.branchItems.addAll(parent.branchItems);
            }
            if (node != null) {
                this.branchItems.add(node.from());
            }
            this.node = node;
        }

        protected boolean addNode(NODE node) {
            if (node.to().isEmpty()) {
                this.children.add(new Tree<NODE, T>(null, node));
                return true;
            }
            if (this.addIfDepend(node)) {
                return true;
            }
            for (ITree<NODE, T> child : this.children) {
                if (!((Tree)child).addIfDepend(node)) continue;
                return true;
            }
            return false;
        }

        private boolean addIfDepend(NODE node) {
            if (this.branchItems.containsAll(node.to())) {
                this.children.add(new Tree<NODE, T>(this, node));
                return true;
            }
            for (ITree<NODE, T> child : this.children) {
                if (!((Tree)child).addIfDepend(node)) continue;
                return true;
            }
            return false;
        }

        @Override
        public NODE node() {
            return this.node;
        }

        @Override
        public List<ITree<NODE, T>> children() {
            return this.children;
        }
    }

    public static interface Node<T> {
        public T from();

        public Collection<T> to();
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(Node o1, Node o2) {
            if (o2.to().contains(o1.from())) {
                return -1;
            }
            if (o1.to().contains(o2.from())) {
                return 1;
            }
            return 0;
        }
    }

    public static interface ITree<NODE extends Node<T>, T> {
        @Nullable
        public NODE node();

        public List<ITree<NODE, T>> children();
    }
}

