/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.HardwareAbstractionLayer;

public abstract class CdSystemUtils {
    public static final boolean UNMAP_SUPPORTED;
    public static boolean UNMAP_ACTIVATED;
    private static final SystemInfo si;
    private static final HardwareAbstractionLayer hal;
    private static final CentralProcessor proc;

    public static int getIntProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static String getStringProperty(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException stopped) {
            Thread.currentThread().interrupt();
        }
    }

    public static void callGC() {
        CdSystemUtils.callGC(-1L);
    }

    public static void callGC(long sleepMillis) {
        System.gc();
        if (sleepMillis > 0L) {
            CdSystemUtils.sleep(sleepMillis);
        }
    }

    public static void unmap(Logger logger, ByteBuffer buffer) {
        block4: {
            if (!UNMAP_SUPPORTED || !UNMAP_ACTIVATED) {
                return;
            }
            try {
                Method getCleanerMethod = buffer.getClass().getMethod("cleaner", new Class[0]);
                getCleanerMethod.setAccessible(true);
                Object cleaner = getCleanerMethod.invoke((Object)buffer, new Object[0]);
                if (cleaner != null) {
                    cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | RuntimeException | InvocationTargetException ex) {
                if (logger == null) break block4;
                logger.warn((Object)"[mmap] could not unmap buffer", (Throwable)ex);
            }
        }
    }

    public static int availableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String availableProcessorsForLogs() {
        return "%d Physical:%d Logical:%d".formatted(CdSystemUtils.availableProcessors(), proc.getPhysicalProcessorCount(), proc.getLogicalProcessorCount());
    }

    public static double[] getSystemLoadAverage(int n) {
        return proc.getSystemLoadAverage(n);
    }

    static {
        boolean supported;
        UNMAP_ACTIVATED = true;
        try {
            Class.forName("sun.misc.Cleaner");
            Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]);
            supported = true;
        }
        catch (Exception e) {
            supported = false;
        }
        UNMAP_SUPPORTED = supported;
        si = new SystemInfo();
        hal = si.getHardware();
        proc = hal.getProcessor();
    }
}

