/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.exception.CdRuntimeException;
import java.util.Locale;

public abstract class CdSizeUtils {
    private static final String[] COMPUTER_UNITS = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};

    public static String format(double value) {
        return CdSizeUtils.format(Locale.ENGLISH, value);
    }

    public static String format(Locale locale, double value) {
        int curUnit = 0;
        while (value >= 1024.0) {
            value /= 1024.0;
            ++curUnit;
        }
        if (curUnit > COMPUTER_UNITS.length) {
            throw new CdRuntimeException("Cannot convert (unit=2^3*" + curUnit + ")");
        }
        if (value == (double)Math.round(value)) {
            return String.format(locale, "%d%s", Math.round(value), COMPUTER_UNITS[curUnit]);
        }
        if (value < 10.0) {
            return String.format(locale, "%.2f%s", value, COMPUTER_UNITS[curUnit]);
        }
        if (value + 0.05 < 100.0) {
            return String.format(locale, "%.1f%s", value, COMPUTER_UNITS[curUnit]);
        }
        return String.format(locale, "%d%s", Math.round(value), COMPUTER_UNITS[curUnit]);
    }

    public static String format(long value, long formerValue) {
        String res = CdSizeUtils.format(value);
        return formerValue < 0L ? res : res + "(+" + CdSizeUtils.format(value - formerValue) + ")";
    }

    public static String formatEx(Locale locale, double value) {
        int curUnit = 0;
        while (value >= 1024.0) {
            value /= 1024.0;
            ++curUnit;
        }
        if (curUnit > COMPUTER_UNITS.length) {
            throw new CdRuntimeException("Cannot convert (unit=2^3*" + curUnit + ")");
        }
        return String.format(locale, "%,.1f %2s", value, COMPUTER_UNITS[curUnit]);
    }

    public static String[] formatEx_(Locale locale, double value) {
        int curUnit = 0;
        while (value >= 1024.0) {
            value /= 1024.0;
            ++curUnit;
        }
        if (curUnit > COMPUTER_UNITS.length) {
            throw new CdRuntimeException("Cannot convert (unit=2^3*" + curUnit + ")");
        }
        return new String[]{String.format(locale, "%,.1f", value), COMPUTER_UNITS[curUnit]};
    }
}

