/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.system.CdRamUsageEstimator;
import crazydev.common.utils.CdArrayUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.util.ArrayList;
import java.util.List;

public class CdPaginatedByteArrayContainer {
    protected static final long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(new CdPaginatedByteArrayContainer(15));
    private static final long I_SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(42);
    private static final int TRIM_ARRAY_MIN_BYTES = 16;
    protected final int pageBitPos;
    protected final ArrayList<byte[]> bytes = new ArrayList();
    protected final ArrayList<Integer> currentPos = new ArrayList();

    public CdPaginatedByteArrayContainer(int pageSizePos) {
        this.pageBitPos = 32 - pageSizePos;
    }

    private int getPageBitPos() {
        return this.pageBitPos;
    }

    private int getPageMask() {
        return (1 << this.pageBitPos) - 1;
    }

    private int getMaxNumberPages() {
        return this.getPageMask() + 1;
    }

    private int getDefaultPageSize() {
        int pageSizePos = 32 - this.pageBitPos;
        return 1 << pageSizePos;
    }

    public long sizeOf() {
        long size = SHALLOW_SIZE_OF;
        size += CdRamUsageEstimator.shallowSizeOfEx(this.bytes);
        for (byte[] bits : this.bytes) {
            size += CdRamUsageEstimator.sizeOf(bits);
        }
        size += CdRamUsageEstimator.shallowSizeOfEx(this.currentPos);
        return size += (long)this.currentPos.size() * I_SHALLOW_SIZE_OF;
    }

    public void trimAndFreeze() {
        if (this.currentPos.isEmpty()) {
            return;
        }
        this.trim();
        this.currentPos.clear();
    }

    public void trim() {
        for (int i = 0; i < this.bytes.size(); ++i) {
            byte[] array = this.bytes.get(i);
            Integer size = this.currentPos.get(i);
            if (size + 16 >= array.length) continue;
            this.bytes.set(i, CdArrayUtils.trimToSize(array, size));
        }
        this.bytes.trimToSize();
        this.currentPos.trimToSize();
    }

    public int size() {
        return this.bytes.size();
    }

    public List<byte[]> getBytes() {
        return this.bytes;
    }

    public ByteBuffer get(int magicNumber) {
        int page = this.getPage(magicNumber);
        int posInPage = this.getPosInPage(magicNumber);
        byte[] array = this.bytes.get(page);
        char size = (char)(array[posInPage] & 0xFF | (array[posInPage + 1] & 0xFF) << 8);
        ByteBuffer buffer = ByteBuffer.wrap(array, posInPage, size).slice();
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public int add(byte[] serialize) {
        if (this.currentPos.size() != this.bytes.size()) {
            throw new ReadOnlyBufferException();
        }
        int arraySize = serialize.length;
        int page = this.getPageForArray(arraySize);
        int posInPage = this.currentPos.get(page);
        System.arraycopy(serialize, 0, this.bytes.get(page), posInPage, arraySize);
        this.currentPos.set(page, posInPage + arraySize);
        return this.buildMagicNumber(page, posInPage);
    }

    private int getPageForArray(int arraySize) {
        if (this.currentPos.isEmpty()) {
            return this.newPageFor(arraySize);
        }
        Integer pos = this.currentPos.getLast();
        int lastPageSize = this.bytes.getLast().length;
        if (pos + arraySize > lastPageSize) {
            return this.newPageFor(arraySize);
        }
        return this.currentPos.size() - 1;
    }

    private int newPageFor(int arraySize) {
        int defaultPageSize = this.getDefaultPageSize();
        for (int i = 0; i < this.currentPos.size(); ++i) {
            byte[] currentBytes = this.bytes.get(i);
            int pageSizeInBytes = currentBytes.length;
            int expectedSize = this.currentPos.get(i) + arraySize;
            if (expectedSize <= pageSizeInBytes) {
                return i;
            }
            if (expectedSize + 16 > defaultPageSize) continue;
            byte[] ar = new byte[defaultPageSize];
            System.arraycopy(currentBytes, 0, ar, 0, currentBytes.length);
            this.bytes.set(i, ar);
            return i;
        }
        if (this.bytes.size() >= this.getMaxNumberPages()) {
            throw new RuntimeException(this.getErrorInfo() + "too many pages [" + this.bytes.size() + " >= " + this.getMaxNumberPages() + "]");
        }
        int newArraySize = Math.max(arraySize, defaultPageSize);
        this.bytes.add(new byte[newArraySize]);
        this.currentPos.add(0);
        return this.currentPos.size() - 1;
    }

    protected String getErrorInfo() {
        return "[containers] ";
    }

    public int getPage(int magicNumber) {
        return magicNumber & this.getPageMask();
    }

    public int getPosInPage(int magicNumber) {
        return magicNumber >>> this.getPageBitPos();
    }

    public int buildMagicNumber(int page, int posInPage) {
        return page + (posInPage << this.getPageBitPos());
    }
}

