/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.collection.CdIIntArrayList;
import crazydev.common.system.CdRamUsageEstimator;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class CdPackedBitList
implements CdIIntArrayList {
    private static final long SHALLOW_SIZE_OF = CdRamUsageEstimator.shallowSizeOf(new CdPackedBitList(1, 1, 10));
    protected final long[] data;
    protected final int bitWidth;
    protected final int size;
    protected final int minValue;

    public CdPackedBitList(int size, int maxValue) {
        this(size, 0, maxValue);
    }

    public CdPackedBitList(int size, int minValue, int maxValue) {
        if (maxValue < minValue) {
            throw new IllegalArgumentException("Min/Max mismatch : " + minValue + "/" + maxValue);
        }
        this.minValue = maxValue == minValue ? minValue - 1 : minValue;
        this.bitWidth = 32 - Integer.numberOfLeadingZeros(maxValue - this.minValue);
        this.size = size;
        long numLongs = CdPackedBitList.getArraySize(size, this.bitWidth);
        if (CdPackedBitList.isOverSized(numLongs)) {
            throw new IllegalArgumentException(String.format("Requested packed bit list too large: %d elements \u00d7 %d bits", size, this.bitWidth));
        }
        this.data = new long[(int)numLongs];
    }

    protected CdPackedBitList(long[] data, int minValue, int bitWidth, int size) {
        this.data = data;
        this.minValue = minValue;
        this.bitWidth = bitWidth;
        this.size = size;
    }

    private static long getArraySize(long size, int bitWidth) {
        long totalBits = size * (long)bitWidth;
        return totalBits + 63L >> 6;
    }

    private static boolean isOverSized(long numLongs) {
        return numLongs > 0x7FFFFFF7L;
    }

    public CdPackedBitList newEmpty() {
        return new CdPackedBitList(new long[this.data.length], this.minValue, this.bitWidth, this.size);
    }

    public static long estimatedSizeBytes(int size, int minValue, int maxValue) {
        int bitWidth = maxValue == minValue ? 1 : 32 - Integer.numberOfLeadingZeros(maxValue - minValue);
        long numLongs = CdPackedBitList.getArraySize(size, bitWidth);
        return CdPackedBitList.isOverSized(numLongs) ? Long.MAX_VALUE : SHALLOW_SIZE_OF + numLongs * 8L;
    }

    @Override
    public int set(int index, int value) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (value < this.minValue) {
            throw new IllegalArgumentException("Value below expected min value: " + this.minValue);
        }
        long deltaValue = value - this.minValue;
        long mask = -1L >>> 64 - this.bitWidth;
        if ((deltaValue & (mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            throw new IllegalArgumentException("Value too large for bit width");
        }
        int bitIndex = index * this.bitWidth;
        int longIndex = bitIndex >>> 6;
        int bitOffset = bitIndex & 0x3F;
        long val = deltaValue & mask;
        this.data[longIndex] = this.data[longIndex] & ((1L << this.bitWidth) - 1L << bitOffset ^ 0xFFFFFFFFFFFFFFFFL) | val << bitOffset;
        int remainingBits = bitOffset + this.bitWidth - 64;
        if (remainingBits > 0) {
            this.data[longIndex + 1] = this.data[longIndex + 1] & (this.maskL(remainingBits) ^ 0xFFFFFFFFFFFFFFFFL) | val >>> this.bitWidth - remainingBits;
        }
        return -1;
    }

    @Override
    public int getInt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (index >= this.size) {
            return 0;
        }
        int bitIndex = index * this.bitWidth;
        int longIndex = bitIndex >>> 6;
        int bitOffset = bitIndex & 0x3F;
        long value = this.data[longIndex] >>> bitOffset;
        int remainingBits = bitOffset + this.bitWidth - 64;
        if (remainingBits > 0) {
            value |= this.data[longIndex + 1] << this.bitWidth - remainingBits;
        }
        long mask = -1L >>> 64 - this.bitWidth;
        return this.minValue + (int)(value & mask);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long sizeOf() {
        return SHALLOW_SIZE_OF + CdRamUsageEstimator.sizeOf(this.data);
    }

    @Override
    public void trimToSize() {
    }

    private long maskL(int bits) {
        if (bits == 64) {
            return -1L;
        }
        return (1L << Math.min(bits, this.bitWidth)) - 1L;
    }

    @Nullable
    public static CdPackedBitList buildIfCompressing(CdIIntArrayList intList) {
        int size = intList.size();
        if (intList.sizeOf() <= 4L || intList instanceof CdPackedBitList) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < size; ++i) {
            int value = intList.getInt(i);
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        if (CdPackedBitList.estimatedSizeBytes(size, min, max) > intList.sizeOf()) {
            return null;
        }
        CdPackedBitList packed = new CdPackedBitList(size, min, max);
        for (int i = 0; i < size; ++i) {
            packed.set(i, intList.getInt(i));
        }
        return packed;
    }

    @Override
    public CdIIntArrayList toMutable(Supplier<CdIIntArrayList> constructor) {
        CdIIntArrayList list = constructor.get();
        return this.pushAllValues(list);
    }
}

