/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.utils.CdClassUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class CdOperatingSystemUtils {
    private static final OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
    @Nullable
    private static final Method totalPhysicalMemorySize = CdOperatingSystemUtils.setupMethod("getTotalPhysicalMemorySize");
    @Nullable
    private static final Method freePhysicalMemorySize = CdOperatingSystemUtils.setupMethod("getFreePhysicalMemorySize");
    @Nullable
    private static final Method totalSwapSpaceSize = CdOperatingSystemUtils.setupMethod("getTotalSwapSpaceSize");
    @Nullable
    private static final Method freeSwapSpaceSize = CdOperatingSystemUtils.setupMethod("getFreeSwapSpaceSize");

    @Nullable
    static Method setupMethod(String methodName) {
        try {
            Object value;
            Method method = CdClassUtils.getMethod("com.sun.management.OperatingSystemMXBean", methodName);
            if (method != null && OperatingSystemMXBean.class.isAssignableFrom(method.getDeclaringClass()) && (value = method.invoke((Object)osBean, new Object[0])) instanceof Long) {
                return method;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long getTotalPhysicalMemorySize() {
        return CdOperatingSystemUtils.value(totalPhysicalMemorySize);
    }

    public static long getFreePhysicalMemorySize() {
        return CdOperatingSystemUtils.value(freePhysicalMemorySize);
    }

    public static long getTotalSwapSpaceSize() {
        return CdOperatingSystemUtils.value(totalSwapSpaceSize);
    }

    public static long getFreeSwapSpaceSize() {
        return CdOperatingSystemUtils.value(freeSwapSpaceSize);
    }

    public static String getName() {
        return osBean.getName();
    }

    public static String getArch() {
        return osBean.getArch();
    }

    private static long value(@Nullable Method method) {
        if (method != null) {
            try {
                Object value = method.invoke((Object)osBean, new Object[0]);
                if (value instanceof Long) {
                    return (Long)value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1L;
    }
}

