/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingFileUtils;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.util.NetUtils;
import org.crac.Context;
import org.crac.Resource;

public abstract class CdLog4jUtils {
    public static final Resource CRAC = new CRaCResource();
    public static boolean shutdown = false;
    static Level prevConfigurationLevel;

    public static void init() {
    }

    public static void configure(Level level) {
        shutdown = false;
        if (level.equals((Object)prevConfigurationLevel)) {
            return;
        }
        BuiltConfiguration configuration = CdLog4jUtils.createConfiguration(level);
        Configurator.reconfigure((Configuration)configuration);
        prevConfigurationLevel = level;
        CdLog4jUtils.info("[ic3] Log4j 2 console initialized (" + String.valueOf(level) + ")");
    }

    public static BuiltConfiguration createConfiguration(Level threshold) {
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("ic3-console");
        AppenderComponentBuilder console = ((AppenderComponentBuilder)builder.newAppender("Console", "Console").addAttribute("target", "SYSTEM_OUT")).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%20.20t] [%5.5p] (%d{HH:mm:ss.SSS z}) %m%n"));
        RootLoggerComponentBuilder root = (RootLoggerComponentBuilder)builder.newRootLogger(threshold).add(builder.newAppenderRef(console.getName()));
        builder.add(console);
        builder.add(root);
        BuiltConfiguration configuration = (BuiltConfiguration)builder.build();
        return configuration;
    }

    public static void configure(String xml) {
        CdLog4jUtils.info("[ic3] Log4j 2 configure from XML [" + xml + "] started");
        Configurator.reconfigure((URI)NetUtils.toURI((String)xml));
        CdLog4jUtils.info("[ic3] Log4j 2 configure from XML [" + xml + "] done");
    }

    public static void shutdown() {
        shutdown = true;
        try {
            LogManager.shutdown();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void configure() {
        shutdown = false;
        CdLog4jUtils.configure(Level.ALL);
    }

    public static void configureForFile(String filename, Level threshold) {
        shutdown = false;
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("ic3-file");
        AppenderComponentBuilder file = ((AppenderComponentBuilder)builder.newAppender("File", "File").addAttribute("fileName", filename)).add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", "[%20.20t] [%5.5p] (%d{HH:mm:ss.SSS z}) %m%n"));
        RootLoggerComponentBuilder root = (RootLoggerComponentBuilder)builder.newRootLogger(threshold).add(builder.newAppenderRef(file.getName()));
        builder.add(file);
        builder.add(root);
        Configurator.reconfigure((Configuration)((Configuration)builder.build()));
    }

    public static void configureLevel(Level level) {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        LoggerConfig config = context.getConfiguration().getRootLogger();
        Configurator.setAllLevels((String)config.getName(), (Level)level);
    }

    private static void info(String message) {
        org.apache.log4j.Logger.getLogger((String)"icCube.general").info((Object)message);
    }

    static class CRaCResource
    implements Resource {
        public static final Logger LOG = Logger.getLogger("icCube.crac");

        CRaCResource() {
        }

        public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
            for (Appender appender : CRaCResource.log4jAppenders()) {
                if (!(appender instanceof RollingFileAppender)) continue;
                RollingFileAppender rf = (RollingFileAppender)appender;
                LOG.info("[CRaC] Log4j before-checkpoint [%s]".formatted(rf.getFileName()));
                RollingFileUtils.closeOutputStream(rf);
                LOG.info("[CRaC] Log4j before-checkpoint [%s] completed".formatted(rf.getFileName()));
            }
        }

        public void afterRestore(Context<? extends Resource> context) throws Exception {
            for (Appender appender : CRaCResource.log4jAppenders()) {
                if (!(appender instanceof RollingFileAppender)) continue;
                RollingFileAppender rf = (RollingFileAppender)appender;
                LOG.info("[CRaC] Log4j after-restore [%s]".formatted(rf.getFileName()));
                RollingFileUtils.openOutputStream(rf);
                LOG.info("[CRaC] Log4j after-restore [%s] completed".formatted(rf.getFileName()));
            }
        }

        private static Collection<Appender> log4jAppenders() throws Exception {
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            Configuration configuration = loggerContext.getConfiguration();
            Map appenders = configuration.getAppenders();
            return appenders.values();
        }
    }
}

