/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.utils.CdStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public abstract class CdLocaleUtils {
    private static final Map<Locale, List<String>> cache = new ConcurrentHashMap<Locale, List<String>>();

    public static boolean isNotFallback(Locale fallbackLocale, Locale locale) {
        String language;
        String fallbackLanguage = fallbackLocale.getLanguage();
        if (!Objects.equals(fallbackLanguage, language = locale.getLanguage())) {
            return true;
        }
        String fallbackCountry = fallbackLocale.getCountry();
        if (CdStringUtils.isNotNullAndNotBlank(fallbackCountry)) {
            String variant;
            String country = locale.getCountry();
            if (!Objects.equals(fallbackCountry, country)) {
                return true;
            }
            String fallbackVariant = fallbackLocale.getVariant();
            if (CdStringUtils.isNotNullAndNotBlank(fallbackVariant) && !Objects.equals(fallbackVariant, variant = locale.getVariant())) {
                return true;
            }
        }
        return false;
    }

    public static List<String> resolveNameForLocalizationLookup(Locale locale) {
        List<String> cachedNames = cache.get(locale);
        if (cachedNames != null) {
            return cachedNames;
        }
        List<String> names = CdLocaleUtils.createAndCacheNameForLookup(locale);
        return names;
    }

    private static List<String> createAndCacheNameForLookup(Locale locale) {
        ArrayList<String> names = new ArrayList<String>();
        String language = locale.getLanguage();
        if (CdStringUtils.isNullOrBlank(language)) {
            return names;
        }
        String full = locale.toString();
        CdLocaleUtils.add(names, full);
        String variant = locale.getVariant();
        String country = locale.getCountry();
        if (!CdStringUtils.isNullOrBlank(variant)) {
            if (!CdStringUtils.isNullOrBlank(country)) {
                CdLocaleUtils.add(names, language + "_" + country + "_" + variant);
            } else {
                CdLocaleUtils.add(names, language + "__" + variant);
            }
        } else if (!CdStringUtils.isNullOrBlank(country)) {
            CdLocaleUtils.add(names, language + "_" + country);
        }
        CdLocaleUtils.add(names, language);
        cache.put(locale, names);
        return names;
    }

    private static void add(List<String> names, String name) {
        if (!names.contains(name)) {
            names.add(name);
        }
    }

    @Nullable
    public static Locale fromName(String str) {
        if (CdStringUtils.isNullOrBlank(str)) {
            return null;
        }
        for (Locale locale : Locale.getAvailableLocales()) {
            String localeInternalName = locale.toString();
            if (!localeInternalName.equals(str)) continue;
            return locale;
        }
        return null;
    }

    public static Locale fromName(@Nullable String str, Locale defaultLocale) {
        Locale locale = null;
        if (CdStringUtils.isNotNullAndNotBlank(str)) {
            locale = CdLocaleUtils.fromName(str);
        }
        return locale != null ? locale : defaultLocale;
    }
}

