/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import crazydev.common.utils.CdLineReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CdIoUtils {
    private static final HashMap<String, ByteOrderMark> bomMap = new HashMap();

    public static InputStream createInputStreamBOM(File file, String encoding) throws IOException {
        ByteOrderMark boom = bomMap.get(encoding);
        FileInputStream in = boom != null ? ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)new FileInputStream(file))).setByteOrderMarks(new ByteOrderMark[]{boom}).setInclude(false).get() : new FileInputStream(file);
        return in;
    }

    public static InputStream getInputStream(File file, String encoding) throws IOException {
        ZipInputStream inputStream = new ZipInputStream(new FileInputStream(file));
        if (inputStream.getNextEntry() == null) {
            inputStream.close();
            return CdIoUtils.createInputStreamBOM(file, encoding);
        }
        return inputStream;
    }

    public static CdLineReader getFileReader(final List<File> jfiles, final String encoding, final boolean hasHeader) {
        return new CdLineReader(){
            private BufferedReader currentStream;
            private int pos = 0;
            private String currentFileName = "";

            @Override
            public String getCurrentFileName() {
                return this.currentFileName;
            }

            @Override
            public void forEachFileName(Consumer<String> action) {
                jfiles.forEach(file -> action.accept(file.getName()));
            }

            @Override
            @Nullable
            public String readLine() throws IOException {
                String line;
                if (this.currentStream == null) {
                    if (this.pos >= jfiles.size()) {
                        return null;
                    }
                    File file = (File)jfiles.get(this.pos++);
                    this.currentFileName = file.getName();
                    this.currentStream = CdIoUtils.getBufferedReader(file, encoding);
                    if (hasHeader && this.pos > 1) {
                        this.currentStream.readLine();
                    }
                }
                if ((line = this.currentStream.readLine()) == null) {
                    this.currentStream.close();
                    this.currentStream = null;
                    return this.readLine();
                }
                return line;
            }

            @Override
            public void closeQuietly() {
                IOUtils.closeQuietly((Reader)this.currentStream);
                this.pos = 0;
                this.currentStream = null;
            }

            @Override
            public void close() throws IOException {
                if (this.currentStream != null) {
                    this.currentStream.close();
                }
                this.pos = 0;
                this.currentStream = null;
            }
        };
    }

    @NotNull
    public static BufferedReader getBufferedReader(File file, String encoding) throws IOException {
        return new BufferedReader(new InputStreamReader(CdIoUtils.getInputStream(file, encoding), encoding));
    }

    public static List<String> readAllLines(InputStream in) throws IOException {
        try {
            List list = IOUtils.readLines((InputStream)in, (Charset)StandardCharsets.UTF_8);
            return list;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static void closeQuietly(Reader reader) {
        IOUtils.closeQuietly((Reader)reader);
    }

    static {
        bomMap.put(ByteOrderMark.UTF_8.getCharsetName(), ByteOrderMark.UTF_8);
        bomMap.put(ByteOrderMark.UTF_16BE.getCharsetName(), ByteOrderMark.UTF_16BE);
        bomMap.put(ByteOrderMark.UTF_16LE.getCharsetName(), ByteOrderMark.UTF_16LE);
        bomMap.put(ByteOrderMark.UTF_32BE.getCharsetName(), ByteOrderMark.UTF_32BE);
        bomMap.put(ByteOrderMark.UTF_32LE.getCharsetName(), ByteOrderMark.UTF_32LE);
    }
}

