/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CdByteSize {
    static final Pattern PATTERN = Pattern.compile("([\\d.]+)([GMKB]*)", 2);
    static final Map<String, Integer> UNITS = new HashMap<String, Integer>();
    private long size;

    public CdByteSize(long size) {
        this.size = size;
    }

    public static CdByteSize parse(String value) {
        Matcher matcher = PATTERN.matcher(value);
        if (!matcher.find()) {
            throw new RuntimeException("unexpected size value [" + value + "]");
        }
        String count = matcher.group(1);
        String unit = matcher.group(2);
        Integer unitB = UNITS.get(unit.toUpperCase());
        if (unitB == null) {
            unitB = 1;
        }
        long size = (long)(Double.valueOf(count) * (double)unitB.intValue());
        return new CdByteSize(size);
    }

    public long getSize() {
        return this.size;
    }

    public String toString() {
        return String.valueOf(this.size);
    }

    static {
        UNITS.put("G", 0x40000000);
        UNITS.put("M", 0x100000);
        UNITS.put("K", 1024);
        UNITS.put("B", 1);
    }
}

