/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.utils;

import java.io.ObjectStreamField;
import java.util.Arrays;

class CdBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final int BIT_INDEX_MASK = 63;
    private static final long WORD_MASK = -1L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("bits", long[].class)};
    private long[] words;
    private transient int wordsInUse = 0;
    private static final long serialVersionUID = 7997698588986878753L;

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    private void checkInvariants() {
        assert (this.wordsInUse == 0 || this.words[this.wordsInUse - 1] != 0L);
        assert (this.wordsInUse >= 0 && this.wordsInUse <= this.words.length);
        assert (this.wordsInUse == this.words.length || this.words[this.wordsInUse] == 0L);
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0 && this.words[i] == 0L; --i) {
        }
        this.wordsInUse = i + 1;
    }

    public CdBitSet() {
        this.initWords(64);
    }

    private void initWords(int nbits) {
        this.words = new long[CdBitSet.wordIndex(nbits - 1) + 1];
    }

    private void ensureCapacity(int wordsRequired) {
        if (this.words.length < wordsRequired) {
            int request = 2 * Math.max(this.words.length, Integer.highestOneBit(wordsRequired));
            this.words = Arrays.copyOf(this.words, request);
        }
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.ensureCapacity(wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    public void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = CdBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
        this.checkInvariants();
    }

    public boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        this.checkInvariants();
        int wordIndex = CdBitSet.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public int length() {
        if (this.wordsInUse == 0) {
            return 0;
        }
        return 64 * (this.wordsInUse - 1) + (64 - Long.numberOfLeadingZeros(this.words[this.wordsInUse - 1]));
    }

    public boolean isEmpty() {
        return this.wordsInUse == 0;
    }

    public int cardinality() {
        int sum = 0;
        for (int i = 0; i < this.wordsInUse; ++i) {
            sum += Long.bitCount(this.words[i]);
        }
        return sum;
    }

    public int hashCode() {
        long h = 1234L;
        int i = this.wordsInUse;
        while (--i >= 0) {
            h ^= this.words[i] * (long)(i + 1);
        }
        return (int)(h >> 32 ^ h);
    }

    public int size() {
        return this.words.length * 64;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CdBitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CdBitSet set = (CdBitSet)obj;
        this.checkInvariants();
        set.checkInvariants();
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
            this.checkInvariants();
        }
    }
}

