/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.system;

import java.lang.management.ManagementFactory;
import java.lang.management.PlatformManagedObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class CdVirtualMachine {
    public static final String JVM_VENDOR;
    public static final String JVM_VERSION;
    public static final String JVM_NAME;
    public static final String JAVA_VERSION;
    public static final String JAVA_VENDOR;
    public static final String JVM_INFO_STRING;
    public static final String JAVA_INFO_STRING;
    public static final boolean JRE_IS_64BIT;
    private static final EnumSet<JvmFeature> SUPPORTED_FEATURES;
    @Nullable
    public static final Object THE_UNSAFE;
    @Nullable
    public static final Method OBJECT_FIELD_OFFSET_METHOD;
    public static final int NUM_BYTES_BOOLEAN = 1;
    public static final int NUM_BYTES_BYTE = 1;
    public static final int NUM_BYTES_CHAR = 2;
    public static final int NUM_BYTES_SHORT = 2;
    public static final int NUM_BYTES_INT = 4;
    public static final int NUM_BYTES_FLOAT = 4;
    public static final int NUM_BYTES_LONG = 8;
    public static final int NUM_BYTES_DOUBLE = 8;
    public static final int NUM_BYTES_OBJECT_REF;
    public static final int NUM_BYTES_OBJECT_HEADER;
    public static final int NUM_BYTES_ARRAY_HEADER;
    public static final int NUM_BYTES_OBJECT_ALIGNMENT;
    public static final long INTEGER_CACHE_MIN_VALUE;
    public static final long INTEGER_CACHE_MAX_VALUE;
    public static final long LONG_CACHE_MIN_VALUE;
    public static final long LONG_CACHE_MAX_VALUE;
    public static final Map<Class<?>, Integer> PRIMITIVE_SIZES;

    public static boolean isSupportedJVM() {
        return SUPPORTED_FEATURES.size() == JvmFeature.values().length;
    }

    public static void main(String[] args) {
        System.out.println("JVM                : " + JVM_INFO_STRING);
        System.out.println("Java               : " + JAVA_INFO_STRING);
        System.out.println();
        System.out.println("Supported          : " + CdVirtualMachine.isSupportedJVM());
        System.out.println();
        System.out.println("Object Ref.   Size : " + NUM_BYTES_OBJECT_REF);
        System.out.println("Object Header Size : " + NUM_BYTES_OBJECT_HEADER);
        System.out.println("Array Header  Size : " + NUM_BYTES_ARRAY_HEADER);
        System.out.println("Object Alignment   : " + NUM_BYTES_OBJECT_ALIGNMENT);
        System.out.println();
        System.out.println("Integer Min. Cache : " + INTEGER_CACHE_MIN_VALUE);
        System.out.println("Integer Max. Cache : " + INTEGER_CACHE_MAX_VALUE);
        System.out.println();
        System.out.println("Long    Min. Cache : " + LONG_CACHE_MIN_VALUE);
        System.out.println("Long    Max. Cache : " + LONG_CACHE_MAX_VALUE);
    }

    static {
        long longCacheMaxValue;
        long longCacheMinValue;
        int intCacheMaxValue;
        int intCacheMinValue;
        boolean is64Bit;
        JVM_VENDOR = System.getProperty("java.vm.vendor");
        JVM_VERSION = System.getProperty("java.vm.version");
        JVM_NAME = System.getProperty("java.vm.name");
        JAVA_VERSION = System.getProperty("java.version");
        JAVA_VENDOR = System.getProperty("java.vendor");
        JVM_INFO_STRING = JVM_NAME + " : " + JVM_VENDOR + " : " + JVM_VERSION;
        JAVA_INFO_STRING = JAVA_VENDOR + " : " + JAVA_VERSION;
        SUPPORTED_FEATURES = EnumSet.noneOf(JvmFeature.class);
        PRIMITIVE_SIZES = new IdentityHashMap();
        PRIMITIVE_SIZES.put(Boolean.TYPE, 1);
        PRIMITIVE_SIZES.put(Byte.TYPE, 1);
        PRIMITIVE_SIZES.put(Character.TYPE, 2);
        PRIMITIVE_SIZES.put(Short.TYPE, 2);
        PRIMITIVE_SIZES.put(Integer.TYPE, 4);
        PRIMITIVE_SIZES.put(Float.TYPE, 4);
        PRIMITIVE_SIZES.put(Double.TYPE, 8);
        PRIMITIVE_SIZES.put(Long.TYPE, 8);
        Class<?> unsafeClass = null;
        Object unsafe = null;
        try {
            unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = unsafeField.get(null);
        }
        catch (Exception unsafeField) {
            // empty catch block
        }
        THE_UNSAFE = unsafe;
        try {
            int addressSize = ((Number)unsafeClass.getMethod("addressSize", new Class[0]).invoke(unsafe, new Object[0])).intValue();
            is64Bit = addressSize >= 8;
        }
        catch (Exception ignored) {
            String osArch;
            String dataModel = System.getProperty("sun.arch.data.model");
            is64Bit = dataModel != null ? dataModel.indexOf("64") != -1 : (osArch = System.getProperty("os.arch")) != null && osArch.indexOf("64") != -1;
        }
        JRE_IS_64BIT = is64Bit;
        int referenceSize = JRE_IS_64BIT ? 8 : 4;
        try {
            Method arrayIndexScaleM = unsafeClass.getMethod("arrayIndexScale", Class.class);
            referenceSize = ((Number)arrayIndexScaleM.invoke(THE_UNSAFE, Object[].class)).intValue();
            SUPPORTED_FEATURES.add(JvmFeature.OBJECT_REFERENCE_SIZE);
        }
        catch (Exception arrayIndexScaleM) {
            // empty catch block
        }
        int objectHeader = JRE_IS_64BIT ? 8 + referenceSize : 8;
        Method tempObjectFieldOffsetMethod = null;
        try {
            Method objectFieldOffsetM = unsafeClass.getMethod("objectFieldOffset", Field.class);
            Field dummy1Field = DummyTwoLongObject.class.getDeclaredField("dummy1");
            int ofs1 = ((Number)objectFieldOffsetM.invoke(THE_UNSAFE, dummy1Field)).intValue();
            Field dummy2Field = DummyTwoLongObject.class.getDeclaredField("dummy2");
            int ofs2 = ((Number)objectFieldOffsetM.invoke(THE_UNSAFE, dummy2Field)).intValue();
            if (Math.abs(ofs2 - ofs1) == 8) {
                Field baseField = DummyOneFieldObject.class.getDeclaredField("base");
                objectHeader = ((Number)objectFieldOffsetM.invoke(THE_UNSAFE, baseField)).intValue();
                SUPPORTED_FEATURES.add(JvmFeature.FIELD_OFFSETS);
                tempObjectFieldOffsetMethod = objectFieldOffsetM;
            }
        }
        catch (Exception objectFieldOffsetM) {
            // empty catch block
        }
        OBJECT_FIELD_OFFSET_METHOD = tempObjectFieldOffsetMethod;
        int arrayHeader = JRE_IS_64BIT ? 8 + 2 * referenceSize : 12;
        try {
            Method arrayBaseOffsetM = unsafeClass.getMethod("arrayBaseOffset", Class.class);
            arrayHeader = ((Number)arrayBaseOffsetM.invoke(THE_UNSAFE, byte[].class)).intValue();
            SUPPORTED_FEATURES.add(JvmFeature.ARRAY_HEADER_SIZE);
        }
        catch (Exception arrayBaseOffsetM) {
            // empty catch block
        }
        int objectAlignment = 8;
        try {
            Class<PlatformManagedObject> beanClazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean").asSubclass(PlatformManagedObject.class);
            PlatformManagedObject hotSpotBean = ManagementFactory.getPlatformMXBean(beanClazz);
            if (hotSpotBean != null) {
                Method getVMOptionMethod = beanClazz.getMethod("getVMOption", String.class);
                Object vmOption = getVMOptionMethod.invoke((Object)hotSpotBean, "ObjectAlignmentInBytes");
                objectAlignment = Integer.parseInt(vmOption.getClass().getMethod("getValue", new Class[0]).invoke(vmOption, new Object[0]).toString());
                SUPPORTED_FEATURES.add(JvmFeature.OBJECT_ALIGNMENT);
            }
        }
        catch (Exception beanClazz) {
            // empty catch block
        }
        NUM_BYTES_OBJECT_REF = referenceSize;
        NUM_BYTES_OBJECT_HEADER = objectHeader;
        NUM_BYTES_ARRAY_HEADER = arrayHeader;
        NUM_BYTES_OBJECT_ALIGNMENT = objectAlignment;
        for (intCacheMinValue = 0; intCacheMinValue > Integer.MIN_VALUE && Integer.valueOf(intCacheMinValue - 1) == Integer.valueOf(intCacheMinValue - 1) && intCacheMinValue > -1000000; --intCacheMinValue) {
        }
        for (intCacheMaxValue = -1; intCacheMaxValue < Integer.MAX_VALUE && Integer.valueOf(intCacheMaxValue + 1) == Integer.valueOf(intCacheMaxValue + 1) && intCacheMaxValue < 1000000; ++intCacheMaxValue) {
        }
        INTEGER_CACHE_MIN_VALUE = intCacheMinValue;
        INTEGER_CACHE_MAX_VALUE = intCacheMaxValue;
        for (longCacheMinValue = 0L; longCacheMinValue > Long.MIN_VALUE && Long.valueOf(longCacheMinValue - 1L) == Long.valueOf(longCacheMinValue - 1L) && longCacheMinValue > -1000000L; --longCacheMinValue) {
        }
        for (longCacheMaxValue = -1L; longCacheMaxValue < Long.MAX_VALUE && Long.valueOf(longCacheMaxValue + 1L) == Long.valueOf(longCacheMaxValue + 1L) && longCacheMaxValue < 1000000L; ++longCacheMaxValue) {
        }
        LONG_CACHE_MIN_VALUE = longCacheMinValue;
        LONG_CACHE_MAX_VALUE = longCacheMaxValue;
    }

    public static enum JvmFeature {
        OBJECT_REFERENCE_SIZE("Object reference size estimated using array index scale"),
        ARRAY_HEADER_SIZE("Array header size estimated using array based offset"),
        FIELD_OFFSETS("Shallow instance size based on field offsets"),
        OBJECT_ALIGNMENT("Object alignment retrieved from HotSpotDiagnostic MX bean");

        public final String description;

        private JvmFeature(String description) {
            this.description = description;
        }

        public String toString() {
            return super.name() + " (" + this.description + ")";
        }
    }

    private static final class DummyTwoLongObject {
        public long dummy1;
        public long dummy2;

        private DummyTwoLongObject() {
        }
    }

    private static final class DummyOneFieldObject {
        public byte base;

        private DummyOneFieldObject() {
        }
    }
}

