/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.system;

import crazydev.common.system.CdVirtualMachine;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class CdRamUsageEstimator {
    private static long SHALLOW_SIZE_OF_ARRAY = -1L;
    private static long SIZE_OF_BOOLEAN = -1L;
    private static long SIZE_OF_SHORT = -1L;
    private static long SIZE_OF_INT = -1L;
    private static long SIZE_OF_LONG = -1L;
    private static long SIZE_OF_FLOAT = -1L;
    private static long SIZE_OF_DOUBLE = -1L;
    private static long SIZE_OF_LOCAL_DATE = -1L;
    private static long SIZE_OF_LOCAL_DATE_TIME = -1L;

    public static long shallowSizeOf(@Nullable Object obj) {
        if (obj == null) {
            return 0L;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isPrimitive()) {
            return CdVirtualMachine.PRIMITIVE_SIZES.get(clazz).intValue();
        }
        if (clazz.isArray()) {
            throw new RuntimeException("internal error : shallowSizeOf does not expect an array");
        }
        long size = CdVirtualMachine.NUM_BYTES_OBJECT_HEADER;
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                size = CdRamUsageEstimator.adjustForField(size, field);
            }
            clazz = clazz.getSuperclass();
        }
        return CdRamUsageEstimator.alignObjectSize(size);
    }

    public static long shallowSizeOf(Object[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + (long)CdVirtualMachine.NUM_BYTES_OBJECT_REF * (long)arr.length);
    }

    public static long alignObjectSize(long size) {
        return (size += (long)CdVirtualMachine.NUM_BYTES_OBJECT_ALIGNMENT - 1L) - size % (long)CdVirtualMachine.NUM_BYTES_OBJECT_ALIGNMENT;
    }

    private static long adjustForField(long sizeSoFar, Field field) {
        Class<?> type = field.getType();
        int fieldSize = type.isPrimitive() ? CdVirtualMachine.PRIMITIVE_SIZES.get(type) : CdVirtualMachine.NUM_BYTES_OBJECT_REF;
        Method objectFieldOffsetMethod = CdVirtualMachine.OBJECT_FIELD_OFFSET_METHOD;
        if (objectFieldOffsetMethod != null) {
            try {
                long offsetPlusSize = ((Number)objectFieldOffsetMethod.invoke(CdVirtualMachine.THE_UNSAFE, field)).longValue() + (long)fieldSize;
                return Math.max(sizeSoFar, offsetPlusSize);
            }
            catch (Exception ex) {
                throw new RuntimeException("internal error : RAM usage error [" + field.getDeclaringClass().getName() + "#" + field.getName() + "]", ex);
            }
        }
        return sizeSoFar + (long)fieldSize;
    }

    public static long shallowSizeOfEx(@Nullable ArrayList arr) {
        if (arr == null) {
            return 0L;
        }
        long size = SHALLOW_SIZE_OF_ARRAY != -1L ? SHALLOW_SIZE_OF_ARRAY : (SHALLOW_SIZE_OF_ARRAY = CdRamUsageEstimator.shallowSizeOf(arr));
        return size += (long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + (long)CdVirtualMachine.NUM_BYTES_OBJECT_REF * (long)arr.size();
    }

    public static long sizeOf(byte[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(boolean[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + (long)arr.length);
    }

    public static long sizeOf(char[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(String arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length());
    }

    public static long sizeOf(short[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 2L * (long)arr.length);
    }

    public static long sizeOf(int[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(float[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 4L * (long)arr.length);
    }

    public static long sizeOf(long[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(double[] arr) {
        return CdRamUsageEstimator.alignObjectSize((long)CdVirtualMachine.NUM_BYTES_ARRAY_HEADER + 8L * (long)arr.length);
    }

    public static long sizeOf(Boolean obj) {
        return SIZE_OF_BOOLEAN != -1L ? SIZE_OF_BOOLEAN : (SIZE_OF_BOOLEAN = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(Short obj) {
        return SIZE_OF_SHORT != -1L ? SIZE_OF_SHORT : (SIZE_OF_SHORT = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(Integer obj) {
        if ((long)obj.intValue() >= CdVirtualMachine.INTEGER_CACHE_MIN_VALUE && (long)obj.intValue() <= CdVirtualMachine.INTEGER_CACHE_MAX_VALUE) {
            return 0L;
        }
        return SIZE_OF_INT != -1L ? SIZE_OF_INT : (SIZE_OF_INT = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(Long obj) {
        if (obj >= CdVirtualMachine.LONG_CACHE_MIN_VALUE && obj <= CdVirtualMachine.LONG_CACHE_MAX_VALUE) {
            return 0L;
        }
        return SIZE_OF_LONG != -1L ? SIZE_OF_LONG : (SIZE_OF_LONG = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(Float obj) {
        return SIZE_OF_FLOAT != -1L ? SIZE_OF_FLOAT : (SIZE_OF_FLOAT = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(Double obj) {
        return SIZE_OF_DOUBLE != -1L ? SIZE_OF_DOUBLE : (SIZE_OF_DOUBLE = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(LocalDate obj) {
        return SIZE_OF_LOCAL_DATE != -1L ? SIZE_OF_LOCAL_DATE : (SIZE_OF_LOCAL_DATE = CdRamUsageEstimator.shallowSizeOf(obj));
    }

    public static long sizeOf(LocalDateTime obj) {
        return SIZE_OF_LOCAL_DATE_TIME != -1L ? SIZE_OF_LOCAL_DATE_TIME : (SIZE_OF_LOCAL_DATE_TIME = CdRamUsageEstimator.shallowSizeOf(obj));
    }
}

