/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.stream;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public abstract class CdAbstractLogPrintStream
extends PrintStream {
    private final ByteArrayOutputStream stream;
    protected final Logger logger;

    public CdAbstractLogPrintStream(Logger logger) {
        super(new ByteArrayOutputStream());
        this.stream = (ByteArrayOutputStream)this.out;
        this.logger = logger;
    }

    protected abstract void logMessage(String var1);

    @Override
    public void write(int b) {
        if (b == 10) {
            String message = this.stream.toString();
            this.stream.reset();
            this.logMessage(message);
        } else if (b != 13) {
            super.write(b);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        for (int idx = 0; idx < len; ++idx) {
            this.write(buf[off + idx]);
        }
    }

    @Override
    public void close() {
        String message = this.stream.toString();
        this.stream.reset();
        if (message.length() > 0) {
            this.logMessage(message);
        }
        super.close();
    }
}

