/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.security;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public class CdPasswordHash {
    private static Impl key = null;

    public static void init() throws NoSuchAlgorithmException {
        CdPasswordHash.init(10000, 32, 256);
    }

    public static void init(int pwdIterations, int pwdSaltLength, int pwdKeyLength) throws NoSuchAlgorithmException {
        key = new Impl(pwdIterations, pwdSaltLength, pwdKeyLength);
    }

    @Nullable
    public static String encode(String password) {
        if (key == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        try {
            return password == null || password.isEmpty() ? null : key.encode(password);
        }
        catch (InvalidKeySpecException ex) {
            throw new CdRuntimeException((Throwable)ex, "Unexpected");
        }
    }

    public static boolean check(String password, String hash) {
        if (key == null) {
            throw new CdShouldNotBeHereProgrammingException();
        }
        try {
            return hash == null || hash.isEmpty() ? password == null || password.isEmpty() : key.check(password, hash);
        }
        catch (InvalidKeySpecException ex) {
            throw new CdRuntimeException((Throwable)ex, "Unexpected");
        }
    }

    public static void reSeed() {
        if (key != null) {
            key.reSeed();
        }
    }

    private static final class Impl {
        private int iterations;
        private final int saltLen;
        private final int desiredKeyLen;
        private final SecretKeyFactory f = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        private SecureRandom secureRandom;

        private Impl(int iterations, int saltLen, int keyLen) throws NoSuchAlgorithmException {
            this.iterations = iterations;
            this.saltLen = saltLen;
            this.desiredKeyLen = keyLen;
            this.secureRandom = new SecureRandom();
            this.secureRandom.nextBytes(new byte[4]);
        }

        public String encode(String password) throws InvalidKeySpecException {
            byte[] salt = new byte[this.saltLen];
            this.secureRandom.nextBytes(salt);
            return Base64.encodeBase64String((byte[])salt) + "$" + this.hash(password, salt);
        }

        public boolean check(String password, String stored) throws InvalidKeySpecException {
            if (password == null || password.isEmpty()) {
                return false;
            }
            String[] saltAndPass = stored.split("\\$");
            if (saltAndPass.length != 2) {
                return false;
            }
            String hashOfInput = this.hash(password, Base64.decodeBase64((String)saltAndPass[0]));
            return hashOfInput.equals(saltAndPass[1]);
        }

        private String hash(String password, byte[] salt) throws InvalidKeySpecException {
            if (password == null || password.length() == 0) {
                throw new IllegalArgumentException("Empty passwords are not supported.");
            }
            for (int i = 1; i < salt.length; i += 2) {
                salt[i] = (byte)(salt[i] + salt[i - 1]);
            }
            char[] pwd = (password + "\u00f19!\u00c9").toCharArray();
            SecretKey key = this.f.generateSecret(new PBEKeySpec(pwd, salt, this.iterations, this.desiredKeyLen));
            return Base64.encodeBase64String((byte[])key.getEncoded());
        }

        public void reSeed() {
            try {
                this.secureRandom.setSeed(this.secureRandom.generateSeed(16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

