/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.request;

import crazydev.common.request.CdGcEvent;
import crazydev.common.request.CdRequest;
import crazydev.common.request.CdRequestBuffer;
import crazydev.common.request.CdRequestWatcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CdRequestWatcherOutputWriter {
    private static final SimpleDateFormat ERROR_DATE_FORMAT = new SimpleDateFormat("dd-MM-yy HH:mm:ss.SSS");
    private final CdRequestWatcher requestWatcher;
    private final String runId;
    private final String lineSeparator;
    private final ExecutorService service;
    private final Writer errorWriter;
    private final Writer gcEventWriter;
    private final Writer requestWriter;
    private volatile boolean onError;

    public CdRequestWatcherOutputWriter(CdRequestWatcher requestWatcher, String runId, String output) {
        this.requestWatcher = requestWatcher;
        this.runId = runId;
        this.lineSeparator = System.getProperty("line.separator");
        this.service = Executors.newFixedThreadPool(1);
        File where = new File(output);
        if (!where.exists()) {
            throw new RuntimeException("missing output directory [" + where.getAbsolutePath() + "]");
        }
        if (where.isFile()) {
            throw new RuntimeException("the output directory is a file [" + where.getAbsolutePath() + "]");
        }
        try {
            File file = new File(where, "error.txt");
            boolean writeHeader = !file.exists() || file.length() == 0L;
            FileOutputStream out = new FileOutputStream(file, true);
            this.errorWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            if (writeHeader) {
                this.errorWriter.write("RUN_ID, ERR_TIMESTAMP, ERR_MESSAGE");
                this.errorWriter.write(this.lineSeparator);
                this.errorWriter.flush();
            }
            this.errorWriter.write(runId);
            this.errorWriter.write(", ");
            this.errorWriter.write(ERROR_DATE_FORMAT.format(System.currentTimeMillis()));
            this.errorWriter.write(", ");
            this.errorWriter.write("Hello : I am not an error !");
            this.errorWriter.write(this.lineSeparator);
            this.errorWriter.flush();
            file = new File(where, "run.txt");
            writeHeader = !file.exists() || file.length() == 0L;
            out = new FileOutputStream(file, true);
            BufferedWriter runWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            if (writeHeader) {
                runWriter.write("RUN_ID");
                runWriter.write(this.lineSeparator);
            }
            runWriter.write(runId);
            runWriter.write(this.lineSeparator);
            ((Writer)runWriter).flush();
            ((Writer)runWriter).close();
            file = new File(where, "gc-event.txt");
            writeHeader = !file.exists() || file.length() == 0L;
            out = new FileOutputStream(file, true);
            this.gcEventWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            if (writeHeader) {
                this.gcEventWriter.write("RUN_ID, GC_NAME, GC_ACTION, GC_CAUSE, GC_DURATION_MS, GC_START_TIME_MS, GC_END_TIME_MS");
                this.gcEventWriter.write(this.lineSeparator);
                this.gcEventWriter.flush();
            }
            writeHeader = !(file = new File(where, "request.txt")).exists() || file.length() == 0L;
            out = new FileOutputStream(file, true);
            this.requestWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            if (writeHeader) {
                this.requestWriter.write("RUN_ID, REQ_CATEGORY, REQ_TYPE, REQ_MAJOR_GC_DURATION_MS, REQ_HTTP_DURATION_MS, REQ_SERVLET_DURATION_MS, REQ_PAYLOAD_DURATION_MS, REQ_LOAD_SCHEMA_TOKEN_DURATION_MS, REQ_HTTP_START_MS, REQ_HTTP_END_MS, REQ_SERVLET_START_MS, REQ_SERVLET_END_MS, REQ_PAYLOAD_START_MS, REQ_PAYLOAD_END_MS");
                this.requestWriter.write(this.lineSeparator);
                this.requestWriter.flush();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("unexpected IO exception", ex);
        }
    }

    public void shutdown() {
        CdRequestWatcher.LOGGER.info((Object)"[watcher] result writer shutdown requested");
        try {
            this.service.shutdown();
            this.service.awaitTermination(1L, TimeUnit.HOURS);
            CdRequestWatcher.LOGGER.info((Object)"[watcher] result writer underlying service shutdown complete");
        }
        catch (InterruptedException ex) {
            CdRequestWatcher.LOGGER.info((Object)"[watcher] result writer underlying service shutdown interrupted", (Throwable)ex);
        }
        try {
            this.gcEventWriter.close();
        }
        catch (IOException ex) {
            CdRequestWatcher.LOGGER.warn((Object)"[watcher] could not properly close GC events", (Throwable)ex);
        }
        try {
            this.requestWriter.close();
        }
        catch (IOException ex) {
            CdRequestWatcher.LOGGER.warn((Object)"[watcher] could not properly close requests", (Throwable)ex);
        }
        try {
            this.errorWriter.close();
        }
        catch (IOException ex) {
            CdRequestWatcher.LOGGER.warn((Object)"[watcher] could not properly close errors", (Throwable)ex);
        }
        CdRequestWatcher.LOGGER.info((Object)"[watcher] result writer shutdown complete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeError(long timestamp, String error) {
        if (this.onError) {
            return;
        }
        Writer writer = this.errorWriter;
        synchronized (writer) {
            try {
                this.errorWriter.write(this.runId);
                this.errorWriter.write(", ");
                this.errorWriter.write(ERROR_DATE_FORMAT.format(timestamp));
                this.errorWriter.write(", ");
                this.errorWriter.write(error.replace(",", "\",\""));
                this.errorWriter.write(this.lineSeparator);
                this.errorWriter.flush();
            }
            catch (IOException ex) {
                this.onError("[watcher] could not write error", ex);
            }
        }
    }

    public void writeGcEvent(final CdGcEvent gc) {
        this.service.submit(new Runnable(){
            final /* synthetic */ CdRequestWatcherOutputWriter this$0;
            {
                CdRequestWatcherOutputWriter cdRequestWatcherOutputWriter = this$0;
                Objects.requireNonNull(cdRequestWatcherOutputWriter);
                this.this$0 = cdRequestWatcherOutputWriter;
            }

            @Override
            public void run() {
                this.this$0.doWriteGcEvent(gc);
            }
        });
    }

    private void doWriteGcEvent(CdGcEvent gc) {
        if (this.onError) {
            return;
        }
        try {
            this.gcEventWriter.write(this.runId);
            this.gcEventWriter.write(", ");
            this.gcEventWriter.write(gc.getName().getCaption());
            this.gcEventWriter.write(",");
            this.gcEventWriter.write(gc.getAction());
            this.gcEventWriter.write(",");
            this.gcEventWriter.write(gc.getCause());
            this.gcEventWriter.write(",");
            this.gcEventWriter.write(String.valueOf(gc.getDurationMS()));
            this.gcEventWriter.write(",");
            this.gcEventWriter.write(String.valueOf(gc.getStartTimeMS()));
            this.gcEventWriter.write(",");
            this.gcEventWriter.write(String.valueOf(gc.getEndTimeMS()));
            this.gcEventWriter.write(this.lineSeparator);
            this.gcEventWriter.flush();
        }
        catch (IOException ex) {
            this.onError("[watcher] could not write GC events", ex);
        }
    }

    public void writeRequests(final CdRequestBuffer requests) {
        this.service.submit(new Runnable(){
            final /* synthetic */ CdRequestWatcherOutputWriter this$0;
            {
                CdRequestWatcherOutputWriter cdRequestWatcherOutputWriter = this$0;
                Objects.requireNonNull(cdRequestWatcherOutputWriter);
                this.this$0 = cdRequestWatcherOutputWriter;
            }

            @Override
            public void run() {
                this.this$0.doWriteRequests(requests);
            }
        });
    }

    private void doWriteRequests(CdRequestBuffer requests) {
        if (this.onError) {
            return;
        }
        try {
            for (int ii = 0; ii < requests.size(); ++ii) {
                CdRequest request = requests.get(ii);
                this.requestWriter.write(this.runId);
                this.requestWriter.write(",");
                this.requestWriter.write(request.getCategory());
                this.requestWriter.write(",");
                this.requestWriter.write(request.getType());
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getMajorGcDurationMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getHttpDurationMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getServletDurationMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getPayloadDurationMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getLoadSchemaTokenDurationMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getHttpStartTimeMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getHttpCompletedTimeMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getServletStartTimeMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getServletCompletedTimeMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getPayloadStartTimeMS()));
                this.requestWriter.write(",");
                this.requestWriter.write(String.valueOf(request.getPayloadCompletedTimeMS()));
                this.requestWriter.write(this.lineSeparator);
            }
            this.requestWriter.flush();
        }
        catch (IOException ex) {
            this.onError("[watcher] could not write requests", ex);
        }
    }

    private void onError(String message, IOException ex) {
        this.onError = true;
        this.requestWatcher.onOutputWriterError();
        CdRequestWatcher.LOGGER.error((Object)message, (Throwable)ex);
    }
}

