/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.request;

import crazydev.common.request.CdGcEvent;
import crazydev.common.request.CdMajorGcEventTimeLine;
import crazydev.common.request.CdRequest;
import crazydev.common.request.CdRequestBuffer;
import crazydev.common.request.CdRequestWatcherOutputWriter;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.log4j.Logger;

public class CdRequestWatcher {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.request.watcher");
    public static final Logger LOGGER_CONNECTION = Logger.getLogger((String)"icCube.request.watcher.connection");
    public static final Logger LOGGER_GC = Logger.getLogger((String)"icCube.request.watcher.gc");
    public static final Logger LOGGER_PERIODIC = Logger.getLogger((String)"icCube.request.watcher.periodic");
    public static final int DEFAULT_COMPLETED_REQUEST_BATCH_SIZE = 1024;
    public static final int DEFAULT_PERIODIC_PROCESSING_SEC = 5;
    public static final int DEFAULT_COMPLETED_REQUEST_BATCH_PROCESSING_DELAY_SEC = 30;
    private final int completedRequestBatchSize;
    private final int periodicProcessingSec;
    private final int completedRequestBatchProcessingDelaySec;
    private final long jvmStartTimeMS;
    private final List<GarbageCollectorMXBean> gcBeans = new ArrayList<GarbageCollectorMXBean>();
    private final ScheduledExecutorService service;
    private final CdRequestWatcherOutputWriter resultWriter;
    private volatile boolean shutdownRequested;
    private volatile boolean onError;
    private final CdMajorGcEventTimeLine gcTimeLine = new CdMajorGcEventTimeLine();
    private final Map<Long, CdRequest> currentConnectionRequests = new HashMap<Long, CdRequest>();
    private final Object currentCompletedRequestsLOCK = new Object();
    private CdRequestBuffer currentCompletedRequests = new CdRequestBuffer();
    private List<CdRequestBuffer> completedRequestBatches = new ArrayList<CdRequestBuffer>();

    public CdRequestWatcher() {
        this.completedRequestBatchSize = CdRequestWatcher.asInt("completedRequestBatchSize", 1024);
        this.periodicProcessingSec = CdRequestWatcher.asInt("periodicProcessingSec", 5);
        this.completedRequestBatchProcessingDelaySec = CdRequestWatcher.asInt("completedRequestBatchProcessingDelaySec", 30);
        this.service = Executors.newScheduledThreadPool(1);
        String output = System.getProperty("ic3.request.watcher.output", "/tmp/req-watcher");
        this.jvmStartTimeMS = ManagementFactory.getRuntimeMXBean().getStartTime();
        String runId = new SimpleDateFormat("dd-MM-yy HH:mm:ss").format(this.jvmStartTimeMS);
        this.resultWriter = new CdRequestWatcherOutputWriter(this, runId, output);
    }

    private static int asInt(String property, int defaultValue) {
        try {
            String str = System.getProperty("ic3.request.watcher." + property);
            if (str != null) {
                return Integer.parseInt(str);
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return defaultValue;
    }

    public void start() {
        if (this.shutdownRequested) {
            return;
        }
        this.registerGcBeanListeners();
        this.service.scheduleAtFixedRate(new Runnable(this){
            final /* synthetic */ CdRequestWatcher this$0;
            {
                CdRequestWatcher cdRequestWatcher = this$0;
                Objects.requireNonNull(cdRequestWatcher);
                this.this$0 = cdRequestWatcher;
            }

            @Override
            public void run() {
                this.this$0.performPeriodicProcessing();
            }
        }, 1L, this.periodicProcessingSec, TimeUnit.SECONDS);
    }

    public void shutdown() {
        if (this.shutdownRequested) {
            return;
        }
        this.shutdownRequested = true;
        LOGGER.info((Object)"[watcher] shutdown requested");
        try {
            this.service.submit(new Runnable(this){
                final /* synthetic */ CdRequestWatcher this$0;
                {
                    CdRequestWatcher cdRequestWatcher = this$0;
                    Objects.requireNonNull(cdRequestWatcher);
                    this.this$0 = cdRequestWatcher;
                }

                @Override
                public void run() {
                    this.this$0.performPeriodicProcessing();
                }
            });
            this.service.shutdown();
            this.service.awaitTermination(1L, TimeUnit.HOURS);
            LOGGER.info((Object)"[watcher] underlying service shutdown complete");
        }
        catch (InterruptedException ex) {
            LOGGER.info((Object)"[watcher] underlying service shutdown interrupted", (Throwable)ex);
        }
        this.resultWriter.shutdown();
        LOGGER.info((Object)"[watcher] shutdown complete");
    }

    public void onError(String error) {
        this.onError = true;
        this.resultWriter.writeError(System.currentTimeMillis(), error);
    }

    public void onOutputWriterError() {
        this.onError = true;
    }

    public void onGarbageCollectorNotification(Notification notification) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        try {
            Object userData = notification.getUserData();
            if (userData instanceof CompositeDataSupport) {
                CompositeDataSupport data = (CompositeDataSupport)userData;
                String gcName = (String)data.get("gcName");
                String gcAction = (String)data.get("gcAction");
                String gcCause = (String)data.get("gcCause");
                CompositeDataSupport gcInfo = (CompositeDataSupport)data.get("gcInfo");
                long startTime = (Long)gcInfo.get("startTime") + this.jvmStartTimeMS;
                long endTime = (Long)gcInfo.get("endTime") + this.jvmStartTimeMS;
                final CdGcEvent gc = CdGcEvent.create(gcName, gcAction, gcCause, startTime, endTime);
                this.service.schedule(new Runnable(){
                    final /* synthetic */ CdRequestWatcher this$0;
                    {
                        CdRequestWatcher cdRequestWatcher = this$0;
                        Objects.requireNonNull(cdRequestWatcher);
                        this.this$0 = cdRequestWatcher;
                    }

                    @Override
                    public void run() {
                        this.this$0.performGcEventProcessing(gc);
                    }
                }, 0L, TimeUnit.NANOSECONDS);
            }
        }
        catch (Throwable ex) {
            LOGGER.error((Object)("[watcher] unexpected GC notification processing " + notification.toString()), ex);
            this.onError("unexpected GC notification processing: check the logs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpConnectionCreated(Long connectionId) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.remove(connectionId);
            if (currentRequest != null) {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP ongoing request for newly created connection " + connectionId));
                this.onError("internal error : existing HTTP ongoing request for newly created connection " + connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpConnectionOpened(Long connectionId) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.remove(connectionId);
            if (currentRequest != null) {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP ongoing request for newly opened connection " + connectionId));
                this.onError("internal error : existing HTTP ongoing request for newly opened connection " + connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpConnectionClosed(Long connectionId) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            this.currentConnectionRequests.remove(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHttpCompleted(Long connectionId, long timestamp) {
        CdRequest currentRequest;
        if (this.shutdownRequested || this.onError) {
            return;
        }
        long httpStart = timestamp;
        long httpEnd = System.currentTimeMillis();
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            currentRequest = this.currentConnectionRequests.remove(connectionId);
        }
        if (currentRequest == null) {
            currentRequest = new CdRequest(this, connectionId);
        }
        currentRequest.onHttpCompleted(httpStart, httpEnd);
        this.onRequestCompleted(connectionId, currentRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServletStarted(Long connectionId, String requestCategory) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.get(connectionId);
            if (currentRequest == null) {
                currentRequest = new CdRequest(this, connectionId);
                currentRequest.onServletStarted(requestCategory, timestamp);
                this.currentConnectionRequests.put(connectionId, currentRequest);
            } else {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP request for " + requestCategory + " request for connection " + connectionId));
                this.onError("internal error : internal error : existing HTTP request for " + requestCategory + " request for connection " + connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServletCompleted(Long connectionId, String requestCategory) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.get(connectionId);
            if (currentRequest != null) {
                currentRequest.onServletCompleted(timestamp);
            } else {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP request for " + requestCategory + " request for connection " + connectionId));
                this.onError("internal error : internal error : existing HTTP request for " + requestCategory + " request for connection " + connectionId);
            }
        }
    }

    public void onLoadSchemaStarted(Long connectionId) {
        this.onPayloadStarted(connectionId, "LOAD SCHEMA");
    }

    public void onLoadSchemaCompleted(Long connectionId) {
        this.onPayloadCompleted(connectionId, "LOAD SCHEMA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLoadSchemaToken(Long connectionId, long duration) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.get(connectionId);
            if (currentRequest != null) {
                currentRequest.onLoadSchemaToken(duration);
            } else {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP request for LOAD SCHEMA TOKEN request for connection " + connectionId));
                this.onError("internal error : internal error : existing HTTP request for LOAD SCHEMA TOKEN request for connection " + connectionId);
            }
        }
    }

    public void onMdxStarted(Long connectionId, String requestType) {
        this.onPayloadStarted(connectionId, requestType);
    }

    public void onMdxCompleted(Long connectionId, String requestType) {
        this.onPayloadCompleted(connectionId, requestType);
    }

    public void onXmlaStarted(Long connectionId, String requestType) {
        this.onPayloadStarted(connectionId, requestType);
    }

    public void onXmlaCompleted(Long connectionId, String requestType) {
        this.onPayloadCompleted(connectionId, requestType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPayloadStarted(Long connectionId, String requestType) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.get(connectionId);
            if (currentRequest != null) {
                currentRequest.onPayloadStarted(requestType, timestamp);
            } else {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP request for " + requestType + " request for connection " + connectionId));
                this.onError("internal error : internal error : existing HTTP request for " + requestType + " request for connection " + connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPayloadCompleted(Long connectionId, String requestType) {
        if (this.shutdownRequested || this.onError) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        Map<Long, CdRequest> map = this.currentConnectionRequests;
        synchronized (map) {
            CdRequest currentRequest = this.currentConnectionRequests.get(connectionId);
            if (currentRequest != null) {
                currentRequest.onPayloadCompleted(timestamp);
            } else {
                LOGGER.error((Object)("[watcher] internal error : existing HTTP request for " + requestType + " request for connection " + connectionId));
                this.onError("internal error : internal error : existing HTTP request for " + requestType + " request for connection " + connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRequestCompleted(Long connectionId, CdRequest request) {
        CdRequestBuffer requests = null;
        Object object = this.currentCompletedRequestsLOCK;
        synchronized (object) {
            this.currentCompletedRequests.add(request);
            if (this.currentCompletedRequests.size() >= this.completedRequestBatchSize) {
                requests = this.currentCompletedRequests;
                this.currentCompletedRequests = new CdRequestBuffer();
            }
        }
        if (requests != null) {
            final CdRequestBuffer myRequests = requests;
            try {
                this.service.schedule(new Runnable(){
                    final /* synthetic */ CdRequestWatcher this$0;
                    {
                        CdRequestWatcher cdRequestWatcher = this$0;
                        Objects.requireNonNull(cdRequestWatcher);
                        this.this$0 = cdRequestWatcher;
                    }

                    @Override
                    public void run() {
                        this.this$0.performRequestBatchProcessing(myRequests);
                    }
                }, 100L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable ex) {
                LOGGER.error((Object)("[watcher] unexpected request completed processing error for connection " + connectionId), ex);
                this.onError("unexpected request completed processing error for connection " + connectionId);
            }
        }
    }

    private void registerGcBeanListeners() {
        List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean bean : beans) {
            if (!(bean instanceof NotificationEmitter) || this.gcBeans.contains(bean)) continue;
            NotificationEmitter emitter = (NotificationEmitter)((Object)bean);
            ObjectName objectName = bean.getObjectName();
            Object[] pools = bean.getMemoryPoolNames();
            LOGGER_GC.info((Object)("[watcher] Registering GC MXBean : " + objectName.getCanonicalName() + " : " + Arrays.toString(pools)));
            emitter.addNotificationListener(new NotificationListener(this){
                final /* synthetic */ CdRequestWatcher this$0;
                {
                    CdRequestWatcher cdRequestWatcher = this$0;
                    Objects.requireNonNull(cdRequestWatcher);
                    this.this$0 = cdRequestWatcher;
                }

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    this.this$0.onGarbageCollectorNotification(notification);
                }
            }, null, null);
            this.gcBeans.add(bean);
        }
    }

    private void performGcEventProcessing(CdGcEvent gc) {
        if (this.onError) {
            return;
        }
        try {
            if (LOGGER_GC.isDebugEnabled()) {
                LOGGER_GC.debug((Object)("[watcher] GC " + gc.toString()));
            }
            this.resultWriter.writeGcEvent(gc);
            this.gcTimeLine.registerMajorGcEvent(gc);
        }
        catch (Throwable ex) {
            LOGGER.error((Object)"[watcher] unexpected GC event processing", ex);
            this.onError("unexpected GC event processing");
        }
    }

    private void performRequestBatchProcessing(CdRequestBuffer requests) {
        if (this.onError) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            if (!this.doRequestBatchProcessing(now, requests)) {
                this.completedRequestBatches.add(requests);
            }
        }
        catch (Throwable ex) {
            LOGGER.error((Object)"[watcher] unexpected request batch processing error", ex);
            this.onError("unexpected request batch processing error : check the logs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void performPeriodicProcessing() {
        if (this.onError) {
            return;
        }
        if (LOGGER_PERIODIC.isDebugEnabled()) {
            int currentCount;
            int requestCount = this.currentCompletedRequests.size();
            for (CdRequestBuffer cdRequestBuffer : this.completedRequestBatches) {
                requestCount += cdRequestBuffer.size();
            }
            Map<Long, CdRequest> map = this.currentConnectionRequests;
            synchronized (map) {
                currentCount = this.currentConnectionRequests.size();
            }
            LOGGER_PERIODIC.debug((Object)("[watcher] periodic [S] [current : " + currentCount + " ] [batch : " + this.completedRequestBatches.size() + " ] [request : " + requestCount + " ( " + this.currentCompletedRequests.size() + " ) ] [gc-event : " + this.gcTimeLine.size() + " ] [gc : " + this.gcBeans.size() + "]"));
        }
        long now = System.currentTimeMillis();
        this.gcTimeLine.trim(now);
        if (!this.shutdownRequested) {
            this.registerGcBeanListeners();
        }
        if (!this.currentCompletedRequests.isEmpty()) {
            this.completedRequestBatches.add(this.currentCompletedRequests);
            this.currentCompletedRequests = new CdRequestBuffer();
        }
        if (!this.completedRequestBatches.isEmpty()) {
            try {
                void var3_8;
                Object var3_7 = null;
                for (CdRequestBuffer batch : this.completedRequestBatches) {
                    if (this.doRequestBatchProcessing(now, batch)) continue;
                    if (var3_8 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var3_8.add(batch);
                }
                this.completedRequestBatches = var3_8 != null ? var3_8 : new ArrayList<CdRequestBuffer>();
            }
            catch (Throwable throwable) {
                LOGGER.error((Object)"[watcher] unexpected periodic processing error", throwable);
                this.onError("unexpected periodic processing error : check the logs");
            }
        }
        if (LOGGER_PERIODIC.isDebugEnabled()) {
            void var3_13;
            int currentCount;
            int n = this.currentCompletedRequests.size();
            for (CdRequestBuffer batch : this.completedRequestBatches) {
                var3_13 += batch.size();
            }
            Map<Long, CdRequest> map = this.currentConnectionRequests;
            synchronized (map) {
                currentCount = this.currentConnectionRequests.size();
            }
            LOGGER_PERIODIC.debug((Object)("[watcher] periodic [E] [current : " + currentCount + " ] [batch : " + this.completedRequestBatches.size() + " ] [request : " + (int)var3_13 + " ( " + this.currentCompletedRequests.size() + " ) ] [gc-event : " + this.gcTimeLine.size() + " ] [gc : " + this.gcBeans.size() + "]"));
        }
    }

    private boolean doRequestBatchProcessing(long now, CdRequestBuffer requests) {
        long endTimeMS = requests.getEndTimeMS();
        if (this.shutdownRequested || endTimeMS <= this.gcTimeLine.getLastGcEventEndTimeMS() || endTimeMS < now - (long)(this.completedRequestBatchProcessingDelaySec * 1000)) {
            for (int ii = 0; ii < requests.size(); ++ii) {
                CdRequest request = requests.get(ii);
                this.gcTimeLine.attachMajorGcEventToRequest(request);
            }
            this.resultWriter.writeRequests(requests);
            return true;
        }
        return false;
    }
}

