/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.request;

import crazydev.common.request.CdRequestWatcher;

public class CdRequest {
    private final CdRequestWatcher watcher;
    private final long connectionId;
    private String category = "HTTP";
    private String type = "N/A";
    private long majorGcDurationMS = -1L;
    private long httpStartTimeMS = -1L;
    private long httpCompletedTimeMS = -1L;
    private long servletStartTimeMS = -1L;
    private long servletCompletedTimeMS = -1L;
    private long payloadStartTimeMS = -1L;
    private long payloadCompletedTimeMS = -1L;
    private long loadSchemaTokenDurationMS = -1L;

    public CdRequest(CdRequestWatcher watcher, long connectionId) {
        this.watcher = watcher;
        this.connectionId = connectionId;
    }

    public boolean isCompleted() {
        return this.httpStartTimeMS != -1L && this.httpCompletedTimeMS != -1L;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public long getMajorGcDurationMS() {
        return this.majorGcDurationMS;
    }

    public long getHttpStartTimeMS() {
        return this.httpStartTimeMS;
    }

    public long getHttpCompletedTimeMS() {
        return this.httpCompletedTimeMS;
    }

    public long getHttpDurationMS() {
        if (!this.isCompleted()) {
            return -1L;
        }
        return this.httpCompletedTimeMS - this.httpStartTimeMS;
    }

    public long getServletStartTimeMS() {
        return this.servletStartTimeMS;
    }

    public long getServletCompletedTimeMS() {
        return this.servletCompletedTimeMS;
    }

    public long getServletDurationMS() {
        if (this.servletStartTimeMS == -1L || this.servletCompletedTimeMS == -1L) {
            return -1L;
        }
        return this.servletCompletedTimeMS - this.servletStartTimeMS;
    }

    public long getPayloadStartTimeMS() {
        return this.payloadStartTimeMS;
    }

    public long getPayloadCompletedTimeMS() {
        return this.payloadCompletedTimeMS;
    }

    public long getPayloadDurationMS() {
        if (this.payloadStartTimeMS == -1L || this.payloadCompletedTimeMS == -1L) {
            return -1L;
        }
        return this.payloadCompletedTimeMS - this.payloadStartTimeMS;
    }

    public long getLoadSchemaTokenDurationMS() {
        return this.loadSchemaTokenDurationMS;
    }

    public void onMajorGcEvent(long duration) {
        if (this.majorGcDurationMS != -1L) {
            this.watcher.onError("internal error : duplicated major GC duration");
            return;
        }
        this.majorGcDurationMS = duration;
    }

    public void onHttpCompleted(long startTimeStamp, long endTimeStamp) {
        if (endTimeStamp < startTimeStamp) {
            this.watcher.onError("internal error : inconsistent HTTP time [" + startTimeStamp + "] [" + endTimeStamp + "]");
            return;
        }
        if (this.httpCompletedTimeMS != -1L) {
            this.watcher.onError("internal error : duplicated HTTP completed time");
            return;
        }
        this.httpStartTimeMS = startTimeStamp;
        this.httpCompletedTimeMS = endTimeStamp;
        long payloadDurationMS = this.getPayloadDurationMS();
        long servletDurationMS = this.getServletDurationMS();
        long httpDurationMS = this.getHttpDurationMS();
        if (payloadDurationMS != -1L) {
            if (servletDurationMS != -1L && payloadDurationMS > servletDurationMS) {
                this.watcher.onError("internal error : inconsistent request durations [payload : " + payloadDurationMS + "] [servlet : " + servletDurationMS + "]");
            }
            if (payloadDurationMS > httpDurationMS) {
                this.watcher.onError("internal error : inconsistent request durations [payload : " + payloadDurationMS + "] [http : " + httpDurationMS + "]");
            }
        }
        if (servletDurationMS != -1L && servletDurationMS > httpDurationMS) {
            this.watcher.onError("internal error : inconsistent request durations [servlet : " + servletDurationMS + "] [http : " + httpDurationMS + "]");
        }
    }

    public void onServletStarted(String category, long timeStamp) {
        if (this.servletStartTimeMS != -1L) {
            this.watcher.onError("internal error : duplicated servlet started time");
            return;
        }
        this.category = category;
        this.servletStartTimeMS = timeStamp;
    }

    public void onServletCompleted(long timestamp) {
        if (this.servletCompletedTimeMS != -1L) {
            this.watcher.onError("internal error : duplicated servlet completed time");
            return;
        }
        if (timestamp < this.servletStartTimeMS) {
            this.watcher.onError("internal error : inconsistent servlet time [" + this.servletStartTimeMS + "] [" + timestamp + "]");
            return;
        }
        this.servletCompletedTimeMS = timestamp;
    }

    public void onPayloadStarted(String requestType, long timeStamp) {
        if (this.payloadStartTimeMS != -1L) {
            this.watcher.onError("internal error : duplicated payload started time");
            return;
        }
        this.type = requestType;
        this.payloadStartTimeMS = timeStamp;
    }

    public void onPayloadCompleted(long timestamp) {
        if (this.payloadCompletedTimeMS != -1L) {
            this.watcher.onError("internal error : duplicated payload completed time");
            return;
        }
        if (timestamp < this.payloadStartTimeMS) {
            this.watcher.onError("internal error : inconsistent payload time [" + this.payloadStartTimeMS + "] [" + timestamp + "]");
            return;
        }
        this.payloadCompletedTimeMS = timestamp;
    }

    public void onLoadSchemaToken(long duration) {
        if (this.loadSchemaTokenDurationMS != -1L) {
            this.watcher.onError("internal error : duplicated load schema token duration");
            return;
        }
        this.loadSchemaTokenDurationMS = duration;
    }

    public String toString() {
        return "[conn:" + this.connectionId + "][" + this.category + "]";
    }
}

