/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.request;

import crazydev.common.request.CdGcEvent;
import crazydev.common.request.CdRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CdMajorGcEventTimeLine {
    public static final int GC_HISTORY_SEC = 300;
    private final List<CdGcEvent> majorGcEvents = new ArrayList<CdGcEvent>();
    private long lastGcEventEndTimeMS = Long.MIN_VALUE;
    private long lastRequestEndTimeMS = Long.MIN_VALUE;

    public long getLastGcEventEndTimeMS() {
        return this.lastGcEventEndTimeMS;
    }

    public long getLastRequestEndTimeMS() {
        return this.lastRequestEndTimeMS;
    }

    public int size() {
        return this.majorGcEvents.size();
    }

    public void trim(long now) {
        CdGcEvent event;
        int ii;
        if (this.majorGcEvents.isEmpty()) {
            return;
        }
        long past = now - 300000L;
        int removeUntil = -1;
        for (ii = 0; ii < this.majorGcEvents.size() && (event = this.majorGcEvents.get(ii)).getStartTimeMS() < past; ++ii) {
            if (event.getEndTimeMS() >= now - 300000L) continue;
            removeUntil = ii;
        }
        for (ii = 0; ii <= removeUntil; ++ii) {
            this.majorGcEvents.remove(0);
        }
    }

    public void registerMajorGcEvent(CdGcEvent gc) {
        if (!gc.isMajor()) {
            return;
        }
        if (gc.getStartTimeMS() == 0L && gc.getEndTimeMS() == 0L) {
            return;
        }
        if (gc.getStartTimeMS() < this.lastRequestEndTimeMS) {
            throw new RuntimeException("internal error : major GC recorded after request processing [" + this.lastRequestEndTimeMS + "] " + gc.toString());
        }
        if (gc.getEndTimeMS() > this.lastGcEventEndTimeMS) {
            this.lastGcEventEndTimeMS = gc.getEndTimeMS();
        }
        if (this.majorGcEvents.isEmpty()) {
            this.majorGcEvents.add(gc);
            return;
        }
        CdGcEvent last = this.majorGcEvents.get(this.majorGcEvents.size() - 1);
        if (gc.getStartTimeMS() < last.getEndTimeMS()) {
            throw new RuntimeException("internal error : major GC unexpected overlap [" + last.getEndTimeMS() + "] " + gc.toString());
        }
        this.majorGcEvents.add(gc);
    }

    public void attachMajorGcEventToRequest(CdRequest request) {
        if (!request.isCompleted()) {
            request.onMajorGcEvent(-1L);
            return;
        }
        if (request.getHttpCompletedTimeMS() > this.lastRequestEndTimeMS) {
            this.lastRequestEndTimeMS = request.getHttpCompletedTimeMS();
        }
        if (this.majorGcEvents.isEmpty()) {
            request.onMajorGcEvent(0L);
            return;
        }
        MajorGcEventSearchKey.INSTANCE.startTimeMS = request.getHttpStartTimeMS();
        int index = Collections.binarySearch(this.majorGcEvents, MajorGcEventSearchKey.INSTANCE, MajorGcEventComparator.INSTANCE);
        if (index < 0) {
            int insertionPoint = -index - 1;
            if (insertionPoint >= this.majorGcEvents.size()) {
                this.attachMajorGcEventToRequest(request, this.majorGcEvents.size() - 1, -1);
            } else {
                this.attachMajorGcEventToRequest(request, insertionPoint - 1, insertionPoint);
            }
        } else {
            this.attachMajorGcEventToRequest(request, -1, index);
        }
    }

    private void attachMajorGcEventToRequest(CdRequest request, int beforeGcEvent, int afterGcEvent) {
        long gcDuration = 0L;
        if (beforeGcEvent != -1) {
            CdGcEvent before = this.majorGcEvents.get(beforeGcEvent);
            if (request.getHttpStartTimeMS() < before.getEndTimeMS()) {
                gcDuration = before.getEndTimeMS() < request.getHttpCompletedTimeMS() ? (gcDuration += before.getEndTimeMS() - request.getHttpStartTimeMS()) : (gcDuration += request.getHttpDurationMS());
            }
        }
        if (afterGcEvent != -1) {
            CdGcEvent after;
            for (int index = afterGcEvent; index < this.majorGcEvents.size() && (after = this.majorGcEvents.get(index)).getStartTimeMS() < request.getHttpCompletedTimeMS(); ++index) {
                long duration = after.getEndTimeMS() >= request.getHttpCompletedTimeMS() ? request.getHttpCompletedTimeMS() - after.getStartTimeMS() : after.getDurationMS();
                gcDuration += duration;
            }
        }
        request.onMajorGcEvent(gcDuration);
    }

    static class MajorGcEventSearchKey
    extends CdGcEvent {
        static final MajorGcEventSearchKey INSTANCE = new MajorGcEventSearchKey();
        long startTimeMS = Long.MIN_VALUE;

        private MajorGcEventSearchKey() {
            super(null, "?", "?", Long.MIN_VALUE, Long.MAX_VALUE);
        }

        @Override
        public long getStartTimeMS() {
            return this.startTimeMS;
        }
    }

    static class MajorGcEventComparator
    implements Comparator<CdGcEvent> {
        static final MajorGcEventComparator INSTANCE = new MajorGcEventComparator();

        MajorGcEventComparator() {
        }

        @Override
        public int compare(CdGcEvent o1, CdGcEvent o2) {
            return Long.compare(o1.getStartTimeMS(), o2.getStartTimeMS());
        }
    }
}

