/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.repository;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.repository.CdXmlBean;
import crazydev.common.repository.CdXmlBeanFileRepositoryConsumer;
import crazydev.common.repository.CdXmlBeanRepository;
import crazydev.common.repository.CdXmlBeanRepositoryException;
import crazydev.common.utils.CdIoUtils;
import crazydev.common.xml.CdXmlUtils;
import jakarta.xml.bind.DataBindingException;
import jakarta.xml.bind.JAXBException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class CdXmlBeanFileRepository<T extends CdXmlBean>
extends CdXmlBeanRepository<T> {
    private final CdVFileSystem vfs;
    private final File beanDirectory;
    private final String beanFileEncoding;
    private final String beanFileExtension;

    public CdXmlBeanFileRepository(CdVFileSystem vfs, File beanDirectory, String beanFileEncoding, String beanFileExtension, String beanFriendlyTypeName, Class ... classes) {
        super(beanFriendlyTypeName, classes);
        this.vfs = vfs;
        this.beanDirectory = beanDirectory;
        this.beanFileEncoding = beanFileEncoding;
        this.beanFileExtension = beanFileExtension;
    }

    public File getBeanDirectory() {
        return this.beanDirectory;
    }

    public List<T> unmarshallBeans(String relativeDirectory) throws IOException {
        ArrayList queries = new ArrayList();
        this.vfs.forEachFile(new File(this.beanDirectory, relativeDirectory), entry -> entry.toFile().getName().endsWith("." + this.beanFileExtension), vPath -> {
            T bean = this.unmarshallBean(vPath.path.toFile());
            if (bean != null) {
                queries.add(bean);
            }
        });
        return queries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T unmarshallBean(File file) {
        String errInfo = " file [" + file.getAbsolutePath() + "]";
        try {
            InputStream in = CdIoUtils.createInputStreamBOM(file, this.beanFileEncoding);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, this.beanFileEncoding));
            Object t = this.unmarshallBean(file, reader, errInfo);
            return t;
        }
        catch (IOException ex) {
            this.reportUnmarshallBeanError(errInfo, ex);
        }
        finally {
            IOUtils.closeQuietly((Closeable[])new Closeable[0]);
        }
        return null;
    }

    public <E extends Exception> void saveBeanForUX(File parentDirectory, T bean, CdXmlBeanFileRepositoryConsumer<File, byte[], E> callback) throws E {
        File beanFile = bean.getXmlFile();
        if (beanFile == null) {
            beanFile = new File(parentDirectory, this.createUniqueXmlFileName(parentDirectory, bean.getName()));
            bean.setXmlFile(beanFile);
        }
        this.saveBeanForUX(bean.getName(), beanFile, writer -> CdXmlUtils.marshall(writer, bean, this.classes), callback);
    }

    private <E extends Exception> void saveBeanForUX(String beanName, File file, MyMarshaller marshaller, CdXmlBeanFileRepositoryConsumer<File, byte[], E> callback) throws E {
        byte[] tmp = this.marshalBean(beanName, marshaller);
        callback.accept(file, tmp);
    }

    private byte[] marshalBean(String beanName, MyMarshaller marshaller) {
        String errMessage = this.beanFriendlyTypeName + " [" + beanName + "] save error!";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, this.beanFileEncoding));
            marshaller.marshall(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            return out.toByteArray();
        }
        catch (DataBindingException | JAXBException | IOException ex) {
            throw new CdXmlBeanRepositoryException(ex, errMessage);
        }
    }

    private String createUniqueXmlFileName(File parentDirectory, String beanName) {
        String root = CdVFileSystem.toFileName(beanName);
        return root + "." + this.beanFileExtension;
    }

    static interface MyMarshaller {
        public void marshall(Writer var1) throws IOException, JAXBException;
    }
}

