/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.property;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdClassUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CdReadWriteProperty
extends CdProperty {
    private final String name;
    private final boolean mandatoryForUi;
    private final boolean visibleForUi;
    private String groupName;
    private Class<?> type;
    @Nullable
    private Method readMethod;
    @Nullable
    private Method writeMethod;
    private Field field;

    public CdReadWriteProperty(String groupName, Class<?> beanClass, String name) {
        this(beanClass, name, false, true);
        this.groupName = groupName;
    }

    public CdReadWriteProperty(String groupName, Class<?> beanClass, String name, boolean isMandatoryForUi) {
        this(beanClass, name, isMandatoryForUi, true);
        this.groupName = groupName;
    }

    public CdReadWriteProperty(Class<?> beanClass, String name, boolean isMandatoryForUi) {
        this(beanClass, name, isMandatoryForUi, true);
    }

    public CdReadWriteProperty(Class<?> beanClass, String name, boolean mandatoryForUi, boolean visibleForUi) {
        this(beanClass, name, CdProperty.Access.UNDEFINED, Collections.emptyList(), mandatoryForUi, visibleForUi);
    }

    public CdReadWriteProperty(Class<?> beanClass, String name) {
        this(beanClass, name, CdProperty.Access.UNDEFINED);
    }

    public CdReadWriteProperty(Class<?> beanClass, String name, CdProperty.Access access) {
        this(beanClass, name, access, Collections.emptyList());
    }

    public CdReadWriteProperty(Class<?> beanClass, String name, CdProperty.Access access, List<Object> prototypes) {
        this(beanClass, name, access, prototypes, true, true);
    }

    public CdReadWriteProperty(Class<?> beanClass, String name, CdProperty.Access access, List<Object> prototypes, boolean mandatoryForUi, boolean visibleForUi) {
        super(prototypes);
        this.name = name;
        this.mandatoryForUi = mandatoryForUi;
        this.visibleForUi = visibleForUi;
        if (access == CdProperty.Access.FIELD) {
            try {
                this.setupFromField(beanClass, name);
            }
            catch (NoSuchFieldException ex) {
                throw new CdRuntimeException((Throwable)ex, "Missing field for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
        if (access == CdProperty.Access.METHOD) {
            try {
                this.setupFromMethod(beanClass, name);
            }
            catch (IntrospectionException ex) {
                throw new CdRuntimeException((Throwable)ex, "Missing getter/setter for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
        try {
            this.setupFromMethod(beanClass, name);
        }
        catch (IntrospectionException ignored) {
            try {
                this.setupFromField(beanClass, name);
            }
            catch (NoSuchFieldException ex) {
                throw new CdRuntimeException((Throwable)ex, "Missing field for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
    }

    @Override
    @Nullable
    public String getGroupName() {
        return this.groupName != null ? this.groupName : super.getGroupName();
    }

    private void setupFromMethod(Class<?> beanClass, String name) throws IntrospectionException {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(name, beanClass);
        this.readMethod = propertyDescriptor.getReadMethod();
        this.writeMethod = propertyDescriptor.getWriteMethod();
        this.type = propertyDescriptor.getPropertyType();
        this.field = null;
    }

    private void setupFromField(Class<?> beanClass, String name) throws NoSuchFieldException {
        this.field = CdClassUtils.getDeclaredField(beanClass, name);
        if (Modifier.isFinal(this.field.getModifiers())) {
            String mess = "Property field can not be final ! " + this.field.getDeclaringClass().getSimpleName() + ":" + this.field.getName();
            throw new CdShouldNotBeHereProgrammingException(mess);
        }
        this.field.setAccessible(true);
        this.type = this.field.getType();
        this.readMethod = null;
        this.writeMethod = null;
    }

    @Override
    public boolean isMandatoryInUI() {
        return this.mandatoryForUi;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    @Nullable
    public Class<?> getCollectionType() {
        return CdReadWriteProperty.getCollectionType(this.field);
    }

    @Override
    public Object get(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        if (this.readMethod != null) {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        return this.field.get(bean);
    }

    @Override
    public void set(Object bean, Object value) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        if (this.writeMethod != null) {
            this.writeMethod.invoke(bean, value);
        } else {
            this.field.set(bean, value);
        }
    }

    @Override
    public boolean isVisibleInUi() {
        return this.visibleForUi;
    }
}

