/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.property;

import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.property.CdProperty;
import crazydev.common.utils.CdClassUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.Nullable;

public class CdReadProperty
extends CdProperty {
    private final String name;
    private Class<?> type;
    @Nullable
    private Method readMethod;
    private Field field;
    private boolean isVisible;

    public CdReadProperty(Class<?> beanClass, String name) {
        this(beanClass, name, CdProperty.Access.UNDEFINED);
    }

    public CdReadProperty(Class<?> beanClass, String name, boolean isVisible) {
        this(beanClass, name, CdProperty.Access.UNDEFINED);
        this.isVisible = isVisible;
    }

    public CdReadProperty(Class<?> beanClass, String name, CdProperty.Access access) {
        this.name = name;
        if (access == CdProperty.Access.FIELD) {
            try {
                this.setupFromField(beanClass, name);
            }
            catch (NoSuchFieldException ex) {
                throw new CdRuntimeException("Missing field for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
        if (access == CdProperty.Access.METHOD) {
            try {
                this.setupFromGetterMethod(beanClass, name);
            }
            catch (IntrospectionException ex) {
                throw new CdRuntimeException("Missing getter for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
        try {
            this.setupFromGetterMethod(beanClass, name);
        }
        catch (IntrospectionException ignored) {
            try {
                this.setupFromField(beanClass, name);
            }
            catch (NoSuchFieldException ex) {
                throw new CdRuntimeException("Missing field for property [" + name + "] for class [" + beanClass.getName() + "]!");
            }
        }
    }

    private void setupFromField(Class<?> beanClass, String name) throws NoSuchFieldException {
        this.readMethod = null;
        this.field = CdClassUtils.getDeclaredField(beanClass, name);
        this.type = this.field.getType();
        this.field.setAccessible(true);
    }

    private void setupFromGetterMethod(Class<?> beanClass, String name) throws IntrospectionException {
        this.field = null;
        PropertyDescriptor propertyDescriptor = CdReadProperty.createPropertyDescriptor(name, beanClass);
        this.readMethod = propertyDescriptor.getReadMethod();
        this.type = propertyDescriptor.getPropertyType();
    }

    private static PropertyDescriptor createPropertyDescriptor(String name, Class<?> beanClass) throws IntrospectionException {
        try {
            String readMethodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
            return new PropertyDescriptor(name, beanClass, readMethodName, null);
        }
        catch (IntrospectionException ignored) {
            String readMethodName = "is" + name.substring(0, 1).toUpperCase() + name.substring(1);
            return new PropertyDescriptor(name, beanClass, readMethodName, null);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Class<?> getCollectionType() {
        return CdReadProperty.getCollectionType(this.field);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Object get(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        if (this.readMethod != null) {
            return this.readMethod.invoke(bean, new Object[0]);
        }
        return this.field.get(bean);
    }

    @Override
    public void set(Object bean, Object value) {
        throw new CdProgrammingException("Read-only property [" + this.getName() + "]!");
    }

    @Override
    public boolean isVisibleInUi() {
        return this.isVisible;
    }

    @Override
    public boolean isEditableUi() {
        return !this.isVisible;
    }
}

