/*
 * Decompiled with CFR 0.152.
 */
package crazydev.common.property;

import crazydev.common.utils.CdEnumerableForUi;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class CdProperty {
    private List<Object> prototypes;

    public CdProperty() {
        this(Collections.emptyList());
    }

    protected CdProperty(List<Object> prototypes) {
        this.prototypes = prototypes;
    }

    public abstract String getName();

    @Nullable
    public String getGroupName() {
        return null;
    }

    public abstract Class<?> getType();

    public Class<?> getTypeForDefaultEditor() {
        return this.getType();
    }

    @Nullable
    public String getTabularDataId(@Nullable Object model) {
        return null;
    }

    @Nullable
    public CdProperty dependsOn() {
        return null;
    }

    public List<String> getPossibleValues(@Nullable Object modelOwner, @Nullable Object model) {
        return Collections.emptyList();
    }

    public boolean isVisibleInUi() {
        return true;
    }

    public boolean isMandatoryInUI() {
        return true;
    }

    public boolean isReadOnlyInUi() {
        return this.isReadOnly();
    }

    public boolean isForIncrLoad() {
        return false;
    }

    public boolean isForPartitioning() {
        return false;
    }

    @Nullable
    public Class<?> getCollectionType() {
        return null;
    }

    @Nullable
    protected static Class<?> getCollectionType(@Nullable Field field) {
        Type arg;
        ParameterizedType parameterizedType;
        Type[] args;
        if (field == null) {
            return null;
        }
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType && (args = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()) != null && args.length == 1 && (arg = args[0]) instanceof Class) {
            return (Class)arg;
        }
        return null;
    }

    public abstract boolean isReadOnly();

    @Nullable
    public abstract Object get(Object var1) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException;

    public Object getForUX(Object bean) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return this.get(bean);
    }

    public abstract void set(Object var1, Object var2) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException;

    public void setFromUX(Object bean, @Nullable Object value) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        if (this.getType().equals(Boolean.TYPE) && value == null) {
            this.set(bean, false);
        } else if (value instanceof CdEnumerableForUi) {
            this.set(bean, ((CdEnumerableForUi)value).getValue());
        } else {
            this.set(bean, value);
        }
    }

    public List<Object> getAllPrototypes(@Nullable Object model) {
        return this.prototypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdProperty that = (CdProperty)o;
        return this.getName() != null ? this.getName().equals(that.getName()) : that.getName() == null;
    }

    public int hashCode() {
        return this.getName() != null ? this.getName().hashCode() : 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isEditableUi() {
        return true;
    }

    public static enum Access {
        UNDEFINED,
        METHOD,
        FIELD;

    }
}

